/*
 * Decompiled with CFR 0.152.
 */
package com.ailiwean.core.able;

import android.os.Handler;
import com.ailiwean.core.WorkThreadServer;
import com.ailiwean.core.able.LighSolveAble;
import com.ailiwean.core.able.PixsValuesAble;
import com.ailiwean.core.able.XQRScanAbleRotate;
import com.ailiwean.core.able.XQRScanZoomAble;
import java.util.ArrayList;
import java.util.List;

public class AbleManager
extends PixsValuesAble {
    private List<PixsValuesAble> ableList = new ArrayList<PixsValuesAble>();
    WorkThreadServer server;

    private AbleManager(Handler handler) {
        super(handler);
        this.loadAble();
        this.server = WorkThreadServer.createInstance();
    }

    public void loadAble() {
        this.ableList.clear();
        this.ableList.add(new XQRScanZoomAble(this.handler));
        this.ableList.add(new XQRScanAbleRotate(this.handler));
        this.ableList.add(new LighSolveAble(this.handler));
    }

    public static AbleManager createInstance(Handler handler) {
        return new AbleManager(handler);
    }

    @Override
    public void cusAction(byte[] data, int dataWidth, int dataHeight) {
        for (PixsValuesAble able : this.ableList) {
            this.server.post(() -> able.cusAction(data, dataWidth, dataHeight));
        }
    }

    public void release() {
        this.ableList.clear();
        this.server.quit();
    }
}

