/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.cameraview;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.FloatRange;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleObserver;
import com.ailiwean.core.Config;
import com.ailiwean.core.Utils;
import com.ailiwean.core.helper.ZoomHelper;
import com.ailiwean.core.view.LifeOwner;
import com.google.android.cameraview.AspectRatio;
import com.google.android.cameraview.BaseCameraView;
import com.google.android.cameraview.CameraView;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\b\u0010\u001b\u001a\u00020\u0013H\u0016J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\u0006\u0010\"\u001a\u00020\u0013J\n\u0010#\u001a\u0004\u0018\u00010$H&J\u0006\u0010%\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020\u00132\b\b\u0001\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006,"}, d2={"Lcom/google/android/cameraview/BaseCameraView;", "Lcom/google/android/cameraview/CameraView;", "Lcom/ailiwean/core/view/LifeOwner;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "def", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "cameraHandler", "Landroid/os/Handler;", "getCameraHandler", "()Landroid/os/Handler;", "cameraHandler$delegate", "Lkotlin/Lazy;", "checkPermission", "", "closeCamera", "", "lightOperator", "isOpen", "onCameraClose", "camera", "onCameraOpen", "onCreate", "onDestroy", "onPause", "onPictureTake", "data", "", "onPreviewByte", "onResume", "onStop", "openCamera", "provideFloorView", "Landroid/view/View;", "requstPermission", "setZoom", "percent", "", "synchLifeStart", "appCompatActivity", "Landroidx/appcompat/app/AppCompatActivity;", "module_camera_release"})
public abstract class BaseCameraView
extends CameraView
implements LifeOwner {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy cameraHandler$delegate;
    private HashMap _$_findViewCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseCameraView.class), "cameraHandler", "getCameraHandler()Landroid/os/Handler;"))};
    }

    public void onCameraOpen(@NotNull CameraView camera) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)camera), (String)"camera");
        ZoomHelper.INSTANCE.toAutoZoom(this);
    }

    public void onCameraClose(@NotNull CameraView camera) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)camera), (String)"camera");
        ZoomHelper.INSTANCE.close(this);
    }

    public void onPictureTake(@NotNull CameraView camera, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)camera), (String)"camera");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
    }

    public void onPreviewByte(@NotNull CameraView camera, @NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)camera), (String)"camera");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
    }

    @Nullable
    public abstract View provideFloorView();

    public final void synchLifeStart(@NotNull AppCompatActivity appCompatActivity) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"appCompatActivity");
        appCompatActivity.getLifecycle().addObserver((LifecycleObserver)this);
        appCompatActivity.getLifecycle().addObserver((LifecycleObserver)new LifeOwner(this){
            private boolean isSingleLoad;
            final /* synthetic */ BaseCameraView this$0;

            public void onCreate() {
                if (this.this$0.checkPermission()) {
                    this.this$0.openCamera();
                } else {
                    this.isSingleLoad = true;
                    this.this$0.requstPermission();
                }
            }

            public final boolean isSingleLoad() {
                return this.isSingleLoad;
            }

            public final void setSingleLoad(boolean bl) {
                this.isSingleLoad = bl;
            }

            public void onResume() {
                if (!this.isSingleLoad) {
                    this.isSingleLoad = true;
                    return;
                }
                if (this.this$0.checkPermission()) {
                    this.this$0.openCamera();
                }
            }

            public void onPause() {
                this.this$0.closeCamera();
            }

            public void onStop() {
            }

            public void onDestroy() {
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final Handler getCameraHandler() {
        Lazy lazy = this.cameraHandler$delegate;
        BaseCameraView baseCameraView = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    public final void openCamera() {
        this.getCameraHandler().post(new Runnable(this){
            final /* synthetic */ BaseCameraView this$0;

            public final void run() {
                this.this$0.start();
            }
            {
                this.this$0 = baseCameraView;
            }
        });
    }

    public final void closeCamera() {
        this.getCameraHandler().post(new Runnable(this){
            final /* synthetic */ BaseCameraView this$0;

            public final void run() {
                this.this$0.stop();
            }
            {
                this.this$0 = baseCameraView;
            }
        });
    }

    public final void setZoom(@FloatRange(from=0.0, to=1.0) float percent) {
        if (percent == 1.0f) {
            this.mImpl.toZoomMax();
        } else if (percent == 0.0f) {
            this.mImpl.toZoomMin();
        } else {
            this.mImpl.setZoom(percent);
        }
        Config.currentZoom = percent;
    }

    public final void lightOperator(boolean isOpen) {
        this.mImpl.lightOperator(isOpen);
    }

    @Override
    public void onCreate() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
        this.getCameraHandler().getLooper().quit();
    }

    public final boolean checkPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
        } else {
            return true;
        }
        return this.getContext().checkSelfPermission("android.permission.CAMERA") == 0;
    }

    public final void requstPermission() {
        block2: {
            if (Build.VERSION.SDK_INT < 23) break block2;
            Context context = this.getContext();
            if (!(context instanceof Activity)) {
                context = null;
            }
            Activity activity = (Activity)context;
            if (activity != null) {
                activity.requestPermissions(new String[]{"android.permission.CAMERA"}, 200);
            }
        }
    }

    @JvmOverloads
    public BaseCameraView(@NotNull Context context, @Nullable AttributeSet attributeSet, int def) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attributeSet, def);
        Utils.init(context);
        this.setAutoFocus(true);
        this.setAdjustViewBounds(false);
        this.setAspectRatio(AspectRatio.of(4, 3));
        this.addCallback(new CameraView.Callback(){
            private boolean hasFloorView;

            public final boolean getHasFloorView() {
                return this.hasFloorView;
            }

            public final void setHasFloorView(boolean bl) {
                this.hasFloorView = bl;
            }

            @Override
            public void onCameraOpened(@NotNull CameraView cameraView) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
                hand.post(new Runnable(this, cameraView){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ CameraView $cameraView;

                    public final void run() {
                        if (!this.this$0.getHasFloorView()) {
                            View view = this.this$0.this.provideFloorView();
                            if (view != null) {
                                View view2 = view;
                                boolean bl = false;
                                boolean bl2 = false;
                                View it = view2;
                                boolean bl3 = false;
                                this.this$0.this.addView(it, new ViewGroup.LayoutParams(-1, -1));
                            }
                            this.this$0.setHasFloorView(true);
                        }
                        this.this$0.this.onCameraOpen(this.$cameraView);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cameraView = cameraView;
                    }
                });
            }

            @Override
            public void onCameraClosed(@NotNull CameraView cameraView) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
                hand.post(new Runnable(this, cameraView){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ CameraView $cameraView;

                    public final void run() {
                        this.this$0.this.onCameraClose(this.$cameraView);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cameraView = cameraView;
                    }
                });
            }

            @Override
            public void onPictureTaken(@NotNull CameraView cameraView, @NotNull byte[] data) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                hand.post(new Runnable(this, cameraView, data){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ CameraView $cameraView;
                    final /* synthetic */ byte[] $data;

                    public final void run() {
                        this.this$0.this.onPictureTake(this.$cameraView, this.$data);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$cameraView = cameraView;
                        this.$data = byArray;
                    }
                });
            }

            @Override
            public void onPreviewByte(@NotNull CameraView cameraView, @Nullable byte[] data) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)cameraView), (String)"cameraView");
                if (data != null) {
                    this.onPreviewByte(cameraView, data);
                }
            }
        });
        this.cameraHandler$delegate = LazyKt.lazy((Function0)cameraHandler.2.INSTANCE);
    }

    public /* synthetic */ BaseCameraView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BaseCameraView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public BaseCameraView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

