package com.google.android.cameraview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.appcompat.app.AppCompatActivity;

import com.bumptech.glide.Glide;

/**
 * @Package: com.google.android.cameraview
 * @ClassName: ByCameraView
 * @Description:
 * @Author: SWY
 * @CreateDate: 2020-03-25 14:12
 */
public class ByFaceCameraView extends CameraView implements View.OnClickListener {

    PictorBack back;
    private ImageView bt;

    public ByFaceCameraView(Context context) {
        super(context);
        init();
    }

    public ByFaceCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public ByFaceCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        setAutoFocus(true);
        setAspectRatio(AspectRatio.of(3, 4));
        setFacing(FACING_FRONT);
        addCallback(new Callback() {
            @Override
            public void onCameraOpened(CameraView cameraView) {
                loadFloorView();
            }

            @Override
            public void onCameraClosed(CameraView cameraView) {
            }

            @Override
            public void onPictureTaken(CameraView cameraView, byte[] data) {
                bt.setEnabled(true);
                if (back != null)
                    back.onBack(data);
            }
        });
    }

    boolean isload = false;

    @SuppressLint("ClickableViewAccessibility")
    private void loadFloorView() {

        if (isload)
            return;

        ViewGroup rootView = (ViewGroup) LayoutInflater.from(getContext()).
                inflate(R.layout.by_face_layout, this, false);

        ImageView bg = rootView.findViewById(R.id.face_bg);
        Glide.with(this).load(R.drawable.ic_camera_face_bg).into(bg);

        bt = rootView.findViewById(R.id.face_bt);
        bt.setOnClickListener(this);
        bt.setOnTouchListener(new OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_DOWN) {
                    bt.animate().scaleX(1.3f)
                            .scaleY(1.3f)
                            .setDuration(300)
                            .start();
                }
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    bt.animate().scaleY(1f)
                            .scaleX(1f)
                            .setDuration(300)
                            .start();
                }
                return false;
            }
        });

        addView(rootView, new ViewGroup.LayoutParams(-1, -1));
        isload = true;
    }

    @Override
    public void onClick(View v) {
        bt.setEnabled(false);
        takePicture();
    }

    public void synchLifeStart(AppCompatActivity appCompatActivity) {
        appCompatActivity.getLifecycle().addObserver(new LifeOwner() {
            @Override
            public void onCreate() {
                start();
            }

            @Override
            public void onPause() {
                stop();
            }

            @Override
            public void onResume() {
                start();
            }

            @Override
            public void onDestroy() {

            }
        });
    }

    public void regTakePictorBack(PictorBack back) {
        this.back = back;
    }

    public interface PictorBack {
        void onBack(byte[] data);
    }

    public void openTakePicture() {
        bt.setEnabled(true);
    }

    public void closeTakePicture() {
        bt.setEnabled(false);
    }

}
