/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.keyboard;

import android.app.Activity;
import android.content.Context;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.os.Build;
import android.text.Editable;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.kangxin.common.R;
import com.kangxin.common.byh.keyboard.KeyModel;
import com.kangxin.common.byh.keyboard.MyKeyBoardView;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class BaseKeyboard {
    public OnOkClick mOnOkClick = null;
    public onCancelClick mOnCancelClick;
    MyKeyBoardView mKeyboardView;
    Keyboard Keyboard;
    EditText mEditText;
    int layoutResId;
    private Activity mActivity;
    private KeyboardView.OnKeyboardActionListener mOnKeyboardActionListener = new KeyboardView.OnKeyboardActionListener(){

        public void onPress(int primaryCode) {
        }

        public void onRelease(int primaryCode) {
        }

        public void onKey(int primaryCode, int[] keyCodes) {
            Editable editable = BaseKeyboard.this.mEditText.getText();
            int start = BaseKeyboard.this.mEditText.getSelectionStart();
            Keyboard var10001 = BaseKeyboard.this.Keyboard;
            if (primaryCode == -5) {
                if (editable != null && editable.length() > 0 && start > 0) {
                    editable.delete(start - 1, start);
                }
            } else {
                var10001 = BaseKeyboard.this.Keyboard;
                if (primaryCode == -3) {
                    BaseKeyboard.this.hideKeyboard();
                    if (BaseKeyboard.this.mOnCancelClick != null) {
                        BaseKeyboard.this.mOnCancelClick.onCancellClick();
                    }
                } else {
                    var10001 = BaseKeyboard.this.Keyboard;
                    if (primaryCode == -4) {
                        BaseKeyboard.this.hideKeyboard();
                        if (BaseKeyboard.this.mOnOkClick != null) {
                            BaseKeyboard.this.mOnOkClick.onOkClick();
                        }
                    } else {
                        editable.insert(start, (CharSequence)Character.toString((char)primaryCode));
                    }
                }
            }
        }

        public void onText(CharSequence text) {
        }

        public void swipeLeft() {
        }

        public void swipeRight() {
        }

        public void swipeDown() {
        }

        public void swipeUp() {
        }
    };

    public static void hideSystemSofeKeyboard(Context context, EditText editText) {
        int sdkInt = Build.VERSION.SDK_INT;
        if (sdkInt >= 11) {
            try {
                Class<EditText> cls = EditText.class;
                Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke((Object)editText, false);
            }
            catch (SecurityException var5) {
                var5.printStackTrace();
            }
            catch (NoSuchMethodException var6) {
                var6.printStackTrace();
            }
            catch (Exception var7) {
                var7.printStackTrace();
            }
        } else {
            editText.setInputType(0);
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.hideSoftInputFromWindow(editText.getWindowToken(), 0);
    }

    public static void enableSystemSofeKeyboard(EditText editText) {
        try {
            Class<EditText> cls = EditText.class;
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
            setShowSoftInputOnFocus.setAccessible(true);
            setShowSoftInputOnFocus.invoke((Object)editText, true);
        }
        catch (SecurityException var3) {
            var3.printStackTrace();
        }
        catch (NoSuchMethodException var4) {
            var4.printStackTrace();
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
    }

    public void init(Activity activity, int layoutResId) {
        this.mActivity = activity;
        this.layoutResId = layoutResId;
        this.Keyboard = new Keyboard((Context)this.mActivity, layoutResId);
        this.mKeyboardView = (MyKeyBoardView)this.mActivity.findViewById(R.id.keyboard_view);
    }

    public void attachTo(EditText editText) {
        this.mEditText = editText;
        BaseKeyboard.hideSystemSofeKeyboard(this.mActivity.getApplicationContext(), this.mEditText);
        if (this.Keyboard == null) {
            this.Keyboard = new Keyboard((Context)this.mActivity, this.layoutResId);
        }
        if (this.mKeyboardView == null) {
            this.mKeyboardView = (MyKeyBoardView)this.mActivity.findViewById(R.id.keyboard_view);
        }
        this.mKeyboardView.setKeyboard(this.Keyboard);
        this.mKeyboardView.setEnabled(true);
        this.mKeyboardView.setPreviewEnabled(false);
        this.mKeyboardView.setOnKeyboardActionListener(this.mOnKeyboardActionListener);
    }

    public void detach() {
        if (this.mEditText != null) {
            this.mEditText.setOnTouchListener((View.OnTouchListener)null);
            this.mEditText.setOnFocusChangeListener((View.OnFocusChangeListener)null);
            BaseKeyboard.enableSystemSofeKeyboard(this.mEditText);
            this.hideKeyboard();
            this.mEditText = null;
        }
    }

    public boolean isShow() {
        return this.mKeyboardView.getVisibility() == 0;
    }

    public void setOnOkClick(OnOkClick onOkClick) {
        this.mOnOkClick = onOkClick;
    }

    public void setOnCancelClick(onCancelClick onCancelClick2) {
        this.mOnCancelClick = onCancelClick2;
    }

    private boolean isNumber(String str) {
        String wordstr = "0123456789";
        return wordstr.contains(str) && !str.equals("");
    }

    private void randomKeyboardNumber() {
        int i;
        int count;
        List keyList = this.Keyboard.getKeys();
        ArrayList newkeyList = new ArrayList();
        for (count = 0; count < keyList.size(); ++count) {
            if (((Keyboard.Key)keyList.get((int)count)).label == null || !this.isNumber(((Keyboard.Key)keyList.get((int)count)).label.toString())) continue;
            newkeyList.add(keyList.get(count));
        }
        count = newkeyList.size();
        ArrayList<KeyModel> resultList = new ArrayList<KeyModel>();
        LinkedList<KeyModel> temp = new LinkedList<KeyModel>();
        for (int i2 = 0; i2 < count; ++i2) {
            temp.add(new KeyModel(48 + i2, i2 + ""));
        }
        Random rand = new Random();
        for (i = 0; i < count; ++i) {
            int num = rand.nextInt(count - i);
            resultList.add(new KeyModel(((KeyModel)temp.get(num)).getCode(), ((KeyModel)temp.get(num)).getLable()));
            temp.remove(num);
        }
        for (i = 0; i < newkeyList.size(); ++i) {
            ((Keyboard.Key)newkeyList.get((int)i)).label = ((KeyModel)resultList.get(i)).getLable();
            ((Keyboard.Key)newkeyList.get((int)i)).codes[0] = ((KeyModel)resultList.get(i)).getCode();
        }
        this.mKeyboardView.setKeyboard(this.Keyboard);
    }

    public void showKeyboard() {
        BaseKeyboard.hideSystemSofeKeyboard(this.mActivity.getApplicationContext(), this.mEditText);
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 8 || visibility == 4) {
            this.mKeyboardView.setVisibility(0);
        }
    }

    public void hideKeyboard() {
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 0) {
            this.mKeyboardView.setVisibility(8);
        }
    }

    public static interface OnOkClick {
        public void onOkClick();
    }

    public static interface onCancelClick {
        public void onCancellClick();
    }
}

