/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.keyboard;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.util.AttributeSet;
import com.kangxin.common.R;
import java.lang.reflect.Field;
import java.util.List;

public class MyKeyBoardView
extends KeyboardView {
    private Context mContext;
    private Keyboard mKeyBoard;

    public MyKeyBoardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public MyKeyBoardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mContext = context;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mKeyBoard = this.getKeyboard();
        List keys = null;
        if (this.mKeyBoard != null) {
            keys = this.mKeyBoard.getKeys();
        }
        if (keys != null) {
            for (Keyboard.Key key : keys) {
                if (key.codes[0] != -4) continue;
                this.drawKeyBackground(R.drawable.bg_keyboardview_yes, canvas, key);
                this.drawText(canvas, key);
            }
        }
    }

    private void drawKeyBackground(int drawableId, Canvas canvas, Keyboard.Key key) {
        Drawable npd = this.mContext.getResources().getDrawable(drawableId);
        int[] drawableState = key.getCurrentDrawableState();
        if (key.codes[0] != 0) {
            npd.setState(drawableState);
        }
        npd.setBounds(key.x, key.y, key.x + key.width, key.y + key.height);
        npd.draw(canvas);
    }

    private void drawText(Canvas canvas, Keyboard.Key key) {
        Rect bounds = new Rect();
        Paint paint = new Paint();
        paint.setTextAlign(Paint.Align.CENTER);
        paint.setAntiAlias(true);
        paint.setColor(-1);
        if (key.label != null) {
            String label = key.label.toString();
            if (label.length() > 1 && key.codes.length < 2) {
                int keyTextSize = 0;
                try {
                    Field field = KeyboardView.class.getDeclaredField("mLabelTextSize");
                    field.setAccessible(true);
                    keyTextSize = (Integer)field.get((Object)this);
                }
                catch (NoSuchFieldException var11) {
                    var11.printStackTrace();
                }
                catch (IllegalAccessException var12) {
                    var12.printStackTrace();
                }
                paint.setTextSize((float)keyTextSize);
                paint.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                int keyTextSize = 0;
                try {
                    Field field = KeyboardView.class.getDeclaredField("mLabelTextSize");
                    field.setAccessible(true);
                    keyTextSize = (Integer)field.get((Object)this);
                }
                catch (NoSuchFieldException var9) {
                    var9.printStackTrace();
                }
                catch (IllegalAccessException var10) {
                    var10.printStackTrace();
                }
                paint.setTextSize((float)keyTextSize);
                paint.setTypeface(Typeface.DEFAULT);
            }
            paint.getTextBounds(key.label.toString(), 0, key.label.toString().length(), bounds);
            canvas.drawText(key.label.toString(), (float)(key.x + key.width / 2), (float)(key.y + key.height / 2 + bounds.height() / 2), paint);
        } else if (key.icon != null) {
            key.icon.setBounds(key.x + (key.width - key.icon.getIntrinsicWidth()) / 2, key.y + (key.height - key.icon.getIntrinsicHeight()) / 2, key.x + (key.width - key.icon.getIntrinsicWidth()) / 2 + key.icon.getIntrinsicWidth(), key.y + (key.height - key.icon.getIntrinsicHeight()) / 2 + key.icon.getIntrinsicHeight());
            key.icon.draw(canvas);
        }
    }
}

