/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.R;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.footer.ClassicsFooter;
import com.scwang.smartrefresh.layout.header.ClassicsHeader;
import com.scwang.smartrefresh.layout.listener.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import java.util.Collection;

public class SmartRecyclerView
extends RelativeLayout {
    private SmartRefreshLayout mSmartRefreshLayoutView;
    private RecyclerView mRecyclerView;
    private View mPlaceSeatLayoutView;
    private ImageView mPlaceImgView;
    private TextView mPlaceDescView;
    private BaseQuickAdapter mAdapter;
    private int mIndex = 1;

    public SmartRecyclerView(Context context) {
        this(context, null);
    }

    public SmartRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SmartRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View smartRootView = LayoutInflater.from((Context)context).inflate(R.layout.commbyh_smart_recyclerview_list_layout, (ViewGroup)this, false);
        this.addView(smartRootView);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SmartRecyclerView);
        int seatImgSrc = 0;
        String seatDesc = "";
        if (typedArray != null) {
            seatImgSrc = typedArray.getResourceId(R.styleable.SmartRecyclerView_seat_img, 0);
            seatDesc = typedArray.getString(R.styleable.SmartRecyclerView_seat_desc);
            typedArray.recycle();
        }
        this.mSmartRefreshLayoutView = (SmartRefreshLayout)this.findViewById(R.id.smart_refresh_layout);
        this.mSmartRefreshLayoutView.setRefreshHeader((RefreshHeader)new ClassicsHeader(context));
        this.mSmartRefreshLayoutView.setRefreshFooter((RefreshFooter)new ClassicsFooter(context));
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_list);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.mPlaceSeatLayoutView = this.findViewById(R.id.place_seat_layout);
        this.mPlaceImgView = (ImageView)this.findViewById(R.id.place_img);
        if (seatImgSrc != 0) {
            this.mPlaceImgView.setImageResource(seatImgSrc);
        }
        this.mPlaceDescView = (TextView)this.findViewById(R.id.place_seat_desc);
        if (!TextUtils.isEmpty((CharSequence)seatDesc)) {
            this.mPlaceDescView.setText((CharSequence)seatDesc);
        }
    }

    public SmartRecyclerView setAdapter(BaseQuickAdapter baseQuickAdapter) {
        this.mAdapter = baseQuickAdapter;
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)baseQuickAdapter);
        return this;
    }

    public boolean isRefresh() {
        return this.mSmartRefreshLayoutView.isRefreshing() || this.mSmartRefreshLayoutView.isLoading();
    }

    public SmartRecyclerView autoRefresh() {
        this.mSmartRefreshLayoutView.autoRefresh();
        return this;
    }

    public SmartRecyclerView addItemDecoration(@NonNull RecyclerView.ItemDecoration decor) {
        this.mRecyclerView.addItemDecoration(decor);
        return this;
    }

    public SmartRecyclerView setRecyclerViewColor(@ColorInt int color2) {
        this.mRecyclerView.setBackgroundColor(color2);
        return this;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setIndex(int index) {
        this.mIndex = index;
    }

    public void showNoData() {
        if (this.mIndex == 1) {
            this.mSmartRefreshLayoutView.setVisibility(8);
            this.mPlaceSeatLayoutView.setVisibility(0);
        }
    }

    public <T> void loadDatas(Collection<? extends T> newData) {
        this.mSmartRefreshLayoutView.finishRefresh();
        this.mSmartRefreshLayoutView.finishLoadmore();
        if (newData == null || newData.isEmpty() || this.mAdapter == null) {
            if (this.mIndex == 1) {
                this.mSmartRefreshLayoutView.setVisibility(8);
                this.mPlaceSeatLayoutView.setVisibility(0);
            }
            return;
        }
        this.mSmartRefreshLayoutView.setVisibility(0);
        this.mPlaceSeatLayoutView.setVisibility(8);
        if (this.mIndex == 1) {
            this.mAdapter.getData().clear();
            this.mAdapter.addData(newData);
        } else {
            this.mAdapter.addData(this.mAdapter.getItemCount(), newData);
        }
    }

    public void setEnablePullAndLoadMore(boolean isRefresh, boolean isLoadMore) {
        this.mSmartRefreshLayoutView.setEnableRefresh(isRefresh);
        this.mSmartRefreshLayoutView.setEnableLoadmore(isLoadMore);
    }

    public void finishRefAndLoadMore() {
        this.mSmartRefreshLayoutView.finishLoadmore();
        this.mSmartRefreshLayoutView.finishRefresh();
    }

    public void setOnPullRefreshListener(final OnPullRefreshListener onPullRefreshListener) {
        this.mSmartRefreshLayoutView.setOnRefreshListener(new OnRefreshListener(){

            public void onRefresh(RefreshLayout refreshlayout) {
                SmartRecyclerView.this.mIndex = 1;
                onPullRefreshListener.onRefresh(SmartRecyclerView.this.mIndex);
            }
        });
        this.mSmartRefreshLayoutView.setOnLoadmoreListener(new OnLoadmoreListener(){

            public void onLoadmore(RefreshLayout refreshlayout) {
                SmartRecyclerView.this.mIndex++;
                onPullRefreshListener.onLoadMore(SmartRecyclerView.this.mIndex);
            }
        });
    }

    public static interface OnPullRefreshListener {
        public void onRefresh(int var1);

        public void onLoadMore(int var1);
    }
}

