/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.util;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    static SimpleDateFormat dateFormat1 = new SimpleDateFormat("HH:mm");
    static SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy MM-dd HH:mm");
    static SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy MM-dd");
    static SimpleDateFormat dateFormat4 = new SimpleDateFormat("MM-dd");
    static SimpleDateFormat dateFormat5 = new SimpleDateFormat("yyyy");

    public static String formatYearMontnDay(long millisecond) {
        if (millisecond == 0L) {
            return "";
        }
        return dateFormat3.format(millisecond);
    }

    public static String formatTime(Long millisecond) {
        if (millisecond == null || millisecond == 0L) {
            return "";
        }
        return dateFormat2.format(millisecond);
    }

    public static String timestamp2Str(long millisecond) {
        String strTime = "";
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String[] mdataTime = dateFormat.format(millisecond).split("-");
        if (year > Integer.parseInt(mdataTime[0])) {
            strTime = dateFormat2.format(millisecond);
        } else if (year == Integer.parseInt(mdataTime[0])) {
            strTime = month > Integer.parseInt(mdataTime[1]) ? dateFormat2.format(millisecond) : (month == Integer.parseInt(mdataTime[1]) ? (day > Integer.parseInt(mdataTime[2]) ? dateFormat2.format(millisecond) : (day == Integer.parseInt(mdataTime[2]) ? StringsUtils.getString(R.string.common_jintian_) + dateFormat1.format(millisecond) : (day - 1 == Integer.parseInt(mdataTime[2]) ? StringsUtils.getString(R.string.common_zuotian_) + dateFormat1.format(millisecond) : dateFormat2.format(millisecond)))) : dateFormat2.format(millisecond));
        } else if (year < Integer.parseInt(mdataTime[0])) {
            strTime = dateFormat2.format(millisecond);
        }
        return strTime;
    }

    public static String timestamp2StrWithWeek(long millisecond) {
        if (millisecond == 0L) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd hh:mm");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millisecond);
        String week = TimeUtil.getWeek(calendar);
        return sdf.format(calendar.getTime() + " " + week);
    }

    public static String getFormatOverTime(long overtime) {
        if (overtime == 0L) {
            return "";
        }
        String result = "";
        long currentTime = System.currentTimeMillis();
        long totalMinutes = (overtime - currentTime) / 1000L / 60L;
        return result;
    }

    public static String getWeek(Calendar calendar) {
        String Week = StringsUtils.getString(R.string.common_zhou);
        switch (calendar.get(7)) {
            case 1: {
                Week = Week + StringsUtils.getString(R.string.common_ri);
                break;
            }
            case 2: {
                Week = Week + StringsUtils.getString(R.string.common_yi);
                break;
            }
            case 3: {
                Week = Week + StringsUtils.getString(R.string.common_er);
                break;
            }
            case 4: {
                Week = Week + StringsUtils.getString(R.string.common_san);
                break;
            }
            case 5: {
                Week = Week + StringsUtils.getString(R.string.common_si);
                break;
            }
            case 6: {
                Week = Week + StringsUtils.getString(R.string.common_wu);
                break;
            }
            case 7: {
                Week = Week + StringsUtils.getString(R.string.common_liu);
                break;
            }
        }
        return Week;
    }

    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String timeFormat(String time, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        Date date = new Date();
        date.setTime(Long.parseLong(time));
        return simpleDateFormat.format(date);
    }

    public static long stringTimeToLong(String time) {
        try {
            return dateFormat2.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getMonthAndDay(long millisecond) {
        return dateFormat4.format(millisecond);
    }

    public static String getYear(long millisecond) {
        return dateFormat5.format(millisecond);
    }

    public static String leftTime(long time) {
        long overtime = time / 1000L;
        if (overtime > 0L) {
            long m = overtime / 60L;
            long s = overtime - m * 60L;
            return String.format(StringsUtils.getString(R.string.common_shengyushijian__1_02d__2_02d), m, s);
        }
        return "";
    }

    public static String leftTimeTwo(long overtime) {
        if (overtime > 0L) {
            long h = overtime / 1000L / 60L / 60L;
            long m = (overtime - h * 60L * 60L * 1000L) / 1000L / 60L;
            if (h > 0L) {
                return h + StringsUtils.getString(R.string.common_xiaoshi) + m + StringsUtils.getString(R.string.common_fen);
            }
            if (m > 0L) {
                return m + StringsUtils.getString(R.string.common_fen);
            }
            return "0";
        }
        return "0";
    }

    public static String stampToDate(long s, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date date = new Date(s);
        String res = simpleDateFormat.format(date);
        return res;
    }

    public static long dateToLong(String date, String format, long defaultValue) {
        try {
            return new SimpleDateFormat(format).parse(date).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String utc2Local(String utcTime, String utcTimePatten, String localTimePatten) {
        SimpleDateFormat utcFormater = new SimpleDateFormat(utcTimePatten);
        utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date gpsUTCDate = null;
        try {
            gpsUTCDate = utcFormater.parse(utcTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return utcTime;
        }
        SimpleDateFormat localFormater = new SimpleDateFormat(localTimePatten);
        localFormater.setTimeZone(TimeZone.getDefault());
        String localTime = localFormater.format(gpsUTCDate.getTime());
        return localTime;
    }

    public static String utc2Local(String utcTime, String localTimePattern) {
        String utcTimePattern = "yyyy-MM-dd";
        String subTime = "";
        if (utcTime != null && utcTime.toCharArray().length >= 10) {
            subTime = utcTime.substring(10);
        }
        if (subTime.indexOf("+") != -1) {
            subTime = TimeUtil.changeUtcSuffix(subTime, "+");
        }
        if (subTime.indexOf("-") != -1) {
            subTime = TimeUtil.changeUtcSuffix(subTime, "-");
        }
        if ((utcTime = utcTime.substring(0, 10) + subTime).indexOf("T") != -1) {
            utcTimePattern = utcTimePattern + "'T'";
        }
        utcTimePattern = utcTime.indexOf(".") != -1 ? utcTimePattern + " HH:mm:ss.SSS" : utcTimePattern + " HH:mm:ss";
        if (subTime.indexOf("+") != -1 || subTime.indexOf("-") != -1) {
            utcTimePattern = utcTimePattern + "XXX";
        } else if (subTime.indexOf("Z") != -1) {
            utcTimePattern = utcTimePattern + "'Z'";
        }
        if ("yyyy-MM-dd HH:mm:ss".equals(utcTimePattern) || "yyyy-MM-dd HH:mm:ss.SSS".equals(utcTimePattern)) {
            return utcTime;
        }
        SimpleDateFormat utcFormater = new SimpleDateFormat(utcTimePattern);
        utcFormater.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date gpsUtcDate = null;
        try {
            gpsUtcDate = utcFormater.parse(utcTime);
        }
        catch (Exception e) {
            return utcTime;
        }
        SimpleDateFormat localFormater = new SimpleDateFormat(localTimePattern);
        localFormater.setTimeZone(TimeZone.getDefault());
        String localTime = localFormater.format(gpsUtcDate.getTime());
        return localTime;
    }

    private static String changeUtcSuffix(String subTime, String sign) {
        String timeSuffix = null;
        String[] splitTimeArrayOne = subTime.split("\\" + sign);
        String[] splitTimeArrayTwo = splitTimeArrayOne[1].split(":");
        if (splitTimeArrayTwo[0].length() < 2) {
            timeSuffix = "+0" + splitTimeArrayTwo[0] + ":" + splitTimeArrayTwo[1];
            subTime = splitTimeArrayOne[0] + timeSuffix;
            return subTime;
        }
        return subTime;
    }

    public static String getTimeZoneByNumExpress() {
        Calendar cal = Calendar.getInstance();
        TimeZone timeZone = cal.getTimeZone();
        int rawOffset = timeZone.getRawOffset();
        int timeZoneByNumExpress = rawOffset / 3600 / 1000;
        String timeZoneByNumExpressStr = "";
        if (timeZoneByNumExpress > 0 && timeZoneByNumExpress < 10) {
            timeZoneByNumExpressStr = "+0" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress >= 10) {
            timeZoneByNumExpressStr = "+" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress > -10 && timeZoneByNumExpress < 0) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-0" + timeZoneByNumExpress + ":00";
        } else if (timeZoneByNumExpress <= -10) {
            timeZoneByNumExpress = Math.abs(timeZoneByNumExpress);
            timeZoneByNumExpressStr = "-" + timeZoneByNumExpress + ":00";
        } else {
            timeZoneByNumExpressStr = "Z";
        }
        return timeZoneByNumExpressStr;
    }
}

