/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.kangxin.common.R;

public class SuccessTickView
extends View {
    private float mDensity = -1.0f;
    private final float CONST_RADIUS = this.dip2px(1.2f);
    private final float CONST_RECT_WEIGHT = this.dip2px(3.0f);
    private final float CONST_LEFT_RECT_W = this.dip2px(15.0f);
    private final float CONST_RIGHT_RECT_W = this.dip2px(25.0f);
    private final float MIN_LEFT_RECT_W = this.dip2px(3.3f);
    private final float MAX_RIGHT_RECT_W = this.CONST_RIGHT_RECT_W + this.dip2px(6.7f);
    private Paint mPaint;
    private float mMaxLeftRectWidth;
    private float mLeftRectWidth;
    private float mRightRectWidth;
    private boolean mLeftRectGrowMode;

    public SuccessTickView(Context context) {
        super(context);
        this.init();
    }

    public SuccessTickView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(R.color.success_stroke_color));
        this.mLeftRectWidth = this.CONST_LEFT_RECT_W;
        this.mRightRectWidth = this.CONST_RIGHT_RECT_W;
        this.mLeftRectGrowMode = false;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int totalW = this.getWidth();
        int totalH = this.getHeight();
        canvas.rotate(45.0f, (float)(totalW / 2), (float)(totalH / 2));
        totalW = (int)((double)totalW / 1.2);
        totalH = (int)((double)totalH / 1.4);
        this.mMaxLeftRectWidth = ((float)totalW + this.CONST_LEFT_RECT_W) / 2.0f + this.CONST_RECT_WEIGHT - 1.0f;
        RectF leftRect = new RectF();
        if (this.mLeftRectGrowMode) {
            leftRect.left = 0.0f;
            leftRect.right = leftRect.left + this.mLeftRectWidth;
            leftRect.top = ((float)totalH + this.CONST_RIGHT_RECT_W) / 2.0f;
            leftRect.bottom = leftRect.top + this.CONST_RECT_WEIGHT;
        } else {
            leftRect.right = ((float)totalW + this.CONST_LEFT_RECT_W) / 2.0f + this.CONST_RECT_WEIGHT - 1.0f;
            leftRect.left = leftRect.right - this.mLeftRectWidth;
            leftRect.top = ((float)totalH + this.CONST_RIGHT_RECT_W) / 2.0f;
            leftRect.bottom = leftRect.top + this.CONST_RECT_WEIGHT;
        }
        canvas.drawRoundRect(leftRect, this.CONST_RADIUS, this.CONST_RADIUS, this.mPaint);
        RectF rightRect = new RectF();
        rightRect.bottom = ((float)totalH + this.CONST_RIGHT_RECT_W) / 2.0f + this.CONST_RECT_WEIGHT - 1.0f;
        rightRect.left = ((float)totalW + this.CONST_LEFT_RECT_W) / 2.0f;
        rightRect.right = rightRect.left + this.CONST_RECT_WEIGHT;
        rightRect.top = rightRect.bottom - this.mRightRectWidth;
        canvas.drawRoundRect(rightRect, this.CONST_RADIUS, this.CONST_RADIUS, this.mPaint);
    }

    public float dip2px(float dpValue) {
        if (this.mDensity == -1.0f) {
            this.mDensity = this.getResources().getDisplayMetrics().density;
        }
        return dpValue * this.mDensity + 0.5f;
    }

    public void startTickAnim() {
        this.mLeftRectWidth = 0.0f;
        this.mRightRectWidth = 0.0f;
        this.invalidate();
        Animation tickAnim = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                super.applyTransformation(interpolatedTime, t);
                if (0.54 < (double)interpolatedTime && 0.7 >= (double)interpolatedTime) {
                    SuccessTickView.this.mLeftRectGrowMode = true;
                    SuccessTickView.this.mLeftRectWidth = SuccessTickView.this.mMaxLeftRectWidth * ((interpolatedTime - 0.54f) / 0.16f);
                    if (0.65 < (double)interpolatedTime) {
                        SuccessTickView.this.mRightRectWidth = SuccessTickView.this.MAX_RIGHT_RECT_W * ((interpolatedTime - 0.65f) / 0.19f);
                    }
                    SuccessTickView.this.invalidate();
                } else if (0.7 < (double)interpolatedTime && 0.84 >= (double)interpolatedTime) {
                    SuccessTickView.this.mLeftRectGrowMode = false;
                    SuccessTickView.this.mLeftRectWidth = SuccessTickView.this.mMaxLeftRectWidth * (1.0f - (interpolatedTime - 0.7f) / 0.14f);
                    SuccessTickView.this.mLeftRectWidth = SuccessTickView.this.mLeftRectWidth < SuccessTickView.this.MIN_LEFT_RECT_W ? SuccessTickView.this.MIN_LEFT_RECT_W : SuccessTickView.this.mLeftRectWidth;
                    SuccessTickView.this.mRightRectWidth = SuccessTickView.this.MAX_RIGHT_RECT_W * ((interpolatedTime - 0.65f) / 0.19f);
                    SuccessTickView.this.invalidate();
                } else if (0.84 < (double)interpolatedTime && 1.0f >= interpolatedTime) {
                    SuccessTickView.this.mLeftRectGrowMode = false;
                    SuccessTickView.this.mLeftRectWidth = SuccessTickView.this.MIN_LEFT_RECT_W + (SuccessTickView.this.CONST_LEFT_RECT_W - SuccessTickView.this.MIN_LEFT_RECT_W) * ((interpolatedTime - 0.84f) / 0.16f);
                    SuccessTickView.this.mRightRectWidth = SuccessTickView.this.CONST_RIGHT_RECT_W + (SuccessTickView.this.MAX_RIGHT_RECT_W - SuccessTickView.this.CONST_RIGHT_RECT_W) * (1.0f - (interpolatedTime - 0.84f) / 0.16f);
                    SuccessTickView.this.invalidate();
                }
            }
        };
        tickAnim.setDuration(750L);
        tickAnim.setStartOffset(100L);
        this.startAnimation(tickAnim);
    }
}

