/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;
import com.blankj.utilcode.util.SizeUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class SubscribeTimeCandlerView
extends LinearLayoutCompat {
    int year = 2019;
    int month = 5;
    int day = 25;
    private String[] weeks = new String[]{StringsUtils.getString(R.string.commbyh_zhouyi), StringsUtils.getString(R.string.commbyh_zhouer), StringsUtils.getString(R.string.commbyh_zhousan), StringsUtils.getString(R.string.commbyh_zhousi), StringsUtils.getString(R.string.commbyh_zhouwu), StringsUtils.getString(R.string.commbyh_zhouliu), StringsUtils.getString(R.string.commbyh_zhouri)};
    private OnTimeClickListener listener;
    private int contentCount = 14;
    private List<CalendarEntity> contentResult;
    private DateSubView currentSelectDateView = null;
    private DateTime currentDateTime;

    public SubscribeTimeCandlerView(Context context) {
        this(context, null);
    }

    public SubscribeTimeCandlerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SubscribeTimeCandlerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        this.setOrientation(1);
        this.year = LocalDate.now().getYear();
        this.month = LocalDate.now().getMonthOfYear();
        this.day = LocalDate.now().getDayOfMonth();
        this.currentDateTime = new DateTime(this.year, this.month, this.day, 0, 0);
        this.initDateTime();
        View weekView = this.initWeeks();
        this.addView(weekView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        for (int i = 0; i < 3; ++i) {
            DateSubLinearlayout dateSubLinearlayout = new DateSubLinearlayout(this.getContext());
            dateSubLinearlayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-1, -2));
            this.inflateSubView(dateSubLinearlayout, i);
            this.addView((View)dateSubLinearlayout, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(-1, -2));
            View view = new View(this.getContext());
            view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, SizeUtils.dp2px((float)1.0f)));
            view.setBackgroundColor(Color.rgb((int)235, (int)235, (int)235));
            this.addView(view, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, SizeUtils.dp2px((float)1.0f)));
        }
    }

    private View initWeeks() {
        LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(this.getContext());
        for (int i = 0; i < 7; ++i) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)this.weeks[i]);
            textView.setGravity(17);
            textView.setTextColor(-16777216);
            textView.setPadding(0, SizeUtils.dp2px((float)5.0f), 0, SizeUtils.dp2px((float)10.0f));
            textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(SizeUtils.dp2px((float)48.0f), -2, 1.0f));
            linearLayoutCompat.addView((View)textView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(SizeUtils.dp2px((float)50.0f), -2, 1.0f));
        }
        return linearLayoutCompat;
    }

    private void inflateSubView(DateSubLinearlayout dateSubLinearlayout, int index) {
        int count = index * 7 + 7;
        for (int i = 7 * index; i < count && i < this.contentResult.size(); ++i) {
            final DateSubView dateSubView = new DateSubView(this.getContext(), this.contentResult.get(i));
            dateSubView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(SizeUtils.dp2px((float)40.0f), SizeUtils.dp2px((float)30.0f), 1.0f));
            dateSubView.setGravity(17);
            dateSubView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int year = dateSubView.getDateTime().getYear();
                    int month = dateSubView.getDateTime().getMonthOfYear();
                    int day = dateSubView.getDateTime().getDayOfMonth();
                    if (SubscribeTimeCandlerView.this.listener != null) {
                        SubscribeTimeCandlerView.this.listener.onClick(year, month, day);
                        SubscribeTimeCandlerView.this.currentSelectDateView.setTextColor(-16777216);
                        dateSubView.setTextColor(SubscribeTimeCandlerView.this.getResources().getColor(R.color.colorPrimary));
                        SubscribeTimeCandlerView.this.currentSelectDateView = dateSubView;
                    }
                }
            });
            DateSubSubView dateSubSubView = new DateSubSubView(this.getContext(), this.contentResult.get(i));
            LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(this.getContext());
            linearLayoutCompat.setOrientation(1);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -2);
            linearLayoutCompat.setLayoutParams(layoutParams);
            linearLayoutCompat.addView((View)dateSubView, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(SizeUtils.dp2px((float)40.0f), SizeUtils.dp2px((float)60.0f), 1.0f));
            linearLayoutCompat.addView((View)dateSubSubView, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(SizeUtils.dp2px((float)40.0f), SizeUtils.dp2px((float)60.0f), 1.0f));
            dateSubLinearlayout.addView((View)linearLayoutCompat, (ViewGroup.LayoutParams)new LinearLayoutCompat.LayoutParams(SizeUtils.dp2px((float)40.0f), SizeUtils.dp2px((float)60.0f), 1.0f));
        }
    }

    private void initDateTime() {
        int i;
        int i2;
        this.contentResult = new ArrayList<CalendarEntity>();
        int dayOfWeek = this.currentDateTime.getDayOfWeek();
        if (dayOfWeek <= 7) {
            for (i2 = dayOfWeek - 1; i2 >= 0; --i2) {
                this.contentResult.add(new CalendarEntity(this.currentDateTime.plusDays(-1 * i2)));
            }
        }
        for (i2 = 1; i2 < this.contentCount; ++i2) {
            this.contentResult.add(new CalendarEntity(this.currentDateTime.plusDays(i2)));
        }
        CalendarEntity lastDateTime = this.contentResult.get(this.contentResult.size() - 1);
        int lastDayOfWeek = lastDateTime.getDateTime().getDayOfWeek();
        for (i = 1; i <= 7 - lastDayOfWeek; ++i) {
            this.contentResult.add(new CalendarEntity(lastDateTime.dateTime.plusDays(i)));
        }
        for (i = 0; i < this.contentResult.size(); ++i) {
            System.out.println("i == " + this.contentResult.get(i).getDateTime().getDayOfMonth());
        }
    }

    public void setListener(OnTimeClickListener listener2) {
        this.listener = listener2;
    }

    class CalendarEntity {
        DateTime dateTime;

        public CalendarEntity(DateTime dateTime) {
            this.dateTime = dateTime;
        }

        public DateTime getDateTime() {
            return this.dateTime;
        }

        public String getSubTitle() {
            return "";
        }
    }

    class DateSubView
    extends AppCompatTextView {
        CalendarEntity entity;

        public DateSubView(Context context, CalendarEntity entity) {
            super(context);
            this.entity = entity;
            this.setGravity(4);
            this.setText(entity.getDateTime().getDayOfMonth() + "");
            if (this.isSelectable()) {
                this.setTextColor(-16777216);
                this.setClickable(true);
            } else {
                this.setTextColor(-7829368);
                this.setClickable(false);
                this.setEnabled(false);
                this.setFocusable(false);
            }
            if (SubscribeTimeCandlerView.this.currentDateTime.getYear() == entity.getDateTime().getYear() && SubscribeTimeCandlerView.this.currentDateTime.getMonthOfYear() == entity.getDateTime().getMonthOfYear() && SubscribeTimeCandlerView.this.currentDateTime.getDayOfMonth() == entity.getDateTime().getDayOfMonth()) {
                SubscribeTimeCandlerView.this.currentSelectDateView = this;
            }
        }

        public DateTime getDateTime() {
            return this.entity.dateTime;
        }

        private boolean isSelectable() {
            System.out.println(StringsUtils.getString(R.string.commbyh_xiaoyudeshijian) + (this.entity.getDateTime().getMillis() < SubscribeTimeCandlerView.this.currentDateTime.getMillis()));
            System.out.println(StringsUtils.getString(R.string.commbyh_dayudeshijian) + (this.entity.getDateTime().getMillis() > SubscribeTimeCandlerView.this.currentDateTime.plusDays(SubscribeTimeCandlerView.this.contentCount).getMillis()));
            return this.entity.getDateTime().getMillis() >= SubscribeTimeCandlerView.this.currentDateTime.getMillis() && this.entity.getDateTime().getMillis() <= SubscribeTimeCandlerView.this.currentDateTime.plusDays(SubscribeTimeCandlerView.this.contentCount).getMillis();
        }
    }

    class DateSubSubView
    extends AppCompatTextView {
        private CalendarEntity entity;

        public DateSubSubView(Context context, CalendarEntity entity) {
            super(context);
            this.entity = entity;
            this.setGravity(17);
            if (SubscribeTimeCandlerView.this.currentDateTime.getYear() == entity.getDateTime().getYear() && SubscribeTimeCandlerView.this.currentDateTime.getMonthOfYear() == entity.getDateTime().getMonthOfYear() && SubscribeTimeCandlerView.this.currentDateTime.getDayOfMonth() == entity.getDateTime().getDayOfMonth()) {
                this.setText(StringsUtils.getString(R.string.commbyh_jinri));
            }
            if (entity.getDateTime().getMonthOfYear() > SubscribeTimeCandlerView.this.currentDateTime.getMonthOfYear() && entity.getDateTime().getDayOfMonth() == 1) {
                this.setText(entity.getDateTime().getMonthOfYear() + StringsUtils.getString(R.string.commbyh_yue));
            }
        }
    }

    class DateSubLinearlayout
    extends LinearLayoutCompat {
        public DateSubLinearlayout(Context context) {
            super(context);
            this.setOrientation(0);
        }
    }

    public static interface OnTimeClickListener {
        public void onClick(int var1, int var2, int var3);
    }
}

