/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http.helper;

import android.content.Context;
import com.kangxin.common.http.interceptor.AddCookieInterceptor;
import com.kangxin.common.http.interceptor.SaveCookieInterceptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

public class OkHttpHelper {
    public static final int DEFAULT_LEVEL = 0;
    public static final int LAST_LEVEL = 50;
    public static final int EARLIEST_LEVEL = 0;
    private OkHttpClient mOkhttpClient;
    private OkHttpClient.Builder mBuilder;
    private ArrayList<com.kangxin.common.http.interceptor.Interceptor> interceptors = new ArrayList();

    public OkHttpClient getOkHttpClient() {
        if (this.mOkhttpClient == null) {
            this.mOkhttpClient = this.createOkClient();
        }
        return this.mOkhttpClient;
    }

    private void createBuilder() {
        this.mBuilder = new OkHttpClient.Builder().connectTimeout(130L, TimeUnit.SECONDS).readTimeout(130L, TimeUnit.SECONDS).writeTimeout(130L, TimeUnit.SECONDS);
    }

    private OkHttpClient createOkClient() {
        if (this.mBuilder == null) {
            this.createBuilder();
        }
        this.addDefaultInterceptor();
        this.mOkhttpClient = this.mBuilder.build();
        return this.mOkhttpClient;
    }

    public OkHttpClient addInterceptor(Interceptor interceptor) {
        return this.addInterceptor(interceptor, 0);
    }

    public OkHttpClient addInterceptor(Interceptor interceptor, int level) {
        com.kangxin.common.http.interceptor.Interceptor levelInterceptor = new com.kangxin.common.http.interceptor.Interceptor(interceptor, level);
        this.interceptors.add(levelInterceptor);
        Collections.sort(this.interceptors);
        this.mBuilder.interceptors().clear();
        for (com.kangxin.common.http.interceptor.Interceptor interceptor1 : this.interceptors) {
            this.mBuilder.addInterceptor(interceptor1.getInterceptor());
        }
        this.mOkhttpClient = this.mBuilder.build();
        return this.mOkhttpClient;
    }

    private void addDefaultInterceptor() {
        this.addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY), 50);
    }

    public void cookieSupport(Context context) {
        this.addInterceptor(new SaveCookieInterceptor(context));
        this.addInterceptor(new AddCookieInterceptor(context));
    }
}

