package com.byh.module.onlineoutser.im.view;

import android.os.Handler;
import android.view.View;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;

import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;


/**
 * Created by poetr on 17/11/3.
 */

public class RecordPopupWindow extends PopupWindow {

    public static final int IDLE = 0;
    public static final int PREPARE = 1;
    public static final int RECORDING = 2;
    public static final int CANCEL = 3;
    public static final int TOO_SHORT = 4;
    public static final int ON_TICK = 5;
    public static final int ON_MAX = 6;

    private static final int ampIcon[] = {
            R.drawable.online_amp1,
            R.drawable.online_amp2,
            R.drawable.online_amp3,
            R.drawable.online_amp4,
            R.drawable.online_amp5,
            R.drawable.online_amp6,
            R.drawable.online_amp7
    };

    private View mVoiceHintAnimArea;
    private View mVoiceRcdHitCancelView;
    private View mTickRoot;
    private TextView mVoiceHintCancelText;
    private ImageView mVoiceHintCancelIcon;
    private View mVoiceHintLoading;
    private View mVoiceHintTooshort;
    private TextView mVoiceNormalWording;
    private TextView mWarning;
    private TextView mTicker;
    private ImageView mVoiceHintAnim;

    private int mCurrentStatus;
    private int mDestinAmp, mCurrentAmp = 0;
    private boolean mRunning;
    private Handler mHandler;
    private Runnable mUpdate = new Runnable() {
        @Override
        public void run() {
            mVoiceHintAnim.setBackgroundResource(ampIcon[mCurrentAmp]);
            if (mCurrentAmp == mDestinAmp) {
                mRunning = false;
                return;
            }
            if (mCurrentAmp < mDestinAmp) {
                mCurrentAmp++;
            } else {
                mCurrentAmp--;
            }
            mHandler.postDelayed(this, 20);
        }
    };

    public RecordPopupWindow(View contentView, int width, int height) {
        super(contentView, width, height, false);
        mVoiceHintAnim = ((ImageView) getContentView().findViewById(R.id.voice_rcd_hint_anim));
        mVoiceHintAnimArea = getContentView().findViewById(R.id.voice_rcd_hint_anim_area);

        mVoiceRcdHitCancelView = getContentView().findViewById(R.id.voice_rcd_hint_cancel_area);
        mVoiceHintCancelText = ((TextView) getContentView().findViewById(R.id.voice_rcd_hint_cancel_text));
        mVoiceHintCancelIcon = ((ImageView) getContentView().findViewById(R.id.voice_rcd_hint_cancel_icon));

        mVoiceHintLoading = getContentView().findViewById(R.id.voice_rcd_hint_loading);
        mVoiceHintTooshort = getContentView().findViewById(R.id.voice_rcd_hint_tooshort);
        mVoiceNormalWording = ((TextView) getContentView().findViewById(R.id.voice_rcd_normal_wording));
        mWarning = (TextView) getContentView().findViewById(R.id.warning);
        mTickRoot = getContentView().findViewById(R.id.tick_root);
        mTicker = (TextView) getContentView().findViewById(R.id.ticker);
    }

    public void displayAmplitude(int amplitude) {
        mDestinAmp = amplitude;
        if (mDestinAmp > ampIcon.length - 1) mDestinAmp = ampIcon.length - 1;
        if (mHandler == null) {
            mHandler = new Handler();
        }
        if (!mRunning) {
            mHandler.post(mUpdate);
            mRunning = true;

        }
    }

    public void updateTick(int tick) {
        mTicker.setText(String.valueOf(tick));
    }

    public void switchStatus(int status) {
        if (mCurrentStatus == ON_TICK && status == RECORDING) return;
        switch (status) {
            case IDLE:
            case RECORDING:
                mVoiceHintAnimArea.setVisibility(View.VISIBLE);
                mVoiceRcdHitCancelView.setVisibility(View.GONE);
                mVoiceHintLoading.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.GONE);
                mTickRoot.setVisibility(View.GONE);
                break;
            case PREPARE:
                mVoiceHintLoading.setVisibility(View.VISIBLE);
                mVoiceHintAnimArea.setVisibility(View.GONE);
                mVoiceRcdHitCancelView.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.GONE);
                mTickRoot.setVisibility(View.GONE);
                break;
            case CANCEL:
                mVoiceHintAnimArea.setVisibility(View.GONE);
                mVoiceRcdHitCancelView.setVisibility(View.VISIBLE);
                mVoiceHintLoading.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.GONE);
                mTickRoot.setVisibility(View.GONE);
                break;
            case TOO_SHORT:
                mVoiceHintAnimArea.setVisibility(View.GONE);
                mVoiceRcdHitCancelView.setVisibility(View.GONE);
                mVoiceHintLoading.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.VISIBLE);
                mTickRoot.setVisibility(View.GONE);
                mWarning.setText(StringsUtils.getString(R.string.onlineoutser_luyinshijiantaiduan));
                break;
            case ON_MAX:
                mVoiceHintAnimArea.setVisibility(View.GONE);
                mVoiceRcdHitCancelView.setVisibility(View.GONE);
                mVoiceHintLoading.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.GONE);
                mTickRoot.setVisibility(View.GONE);
                mWarning.setText(StringsUtils.getString(R.string.onlineoutser_luyinchaoshi));
                break;
            case ON_TICK:
                mVoiceHintAnimArea.setVisibility(View.GONE);
                mVoiceRcdHitCancelView.setVisibility(View.GONE);
                mVoiceHintLoading.setVisibility(View.GONE);
                mVoiceHintTooshort.setVisibility(View.GONE);
                mTickRoot.setVisibility(View.VISIBLE);
                break;
        }
        mCurrentStatus = status;
    }


    public int getStatus() {
        return mCurrentStatus;
    }
}
