package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

import com.kangxin.common.R;

import java.lang.ref.WeakReference;


/**
 * Created by poetr on 17/11/13.
 */

public class ShapedImageView extends AppCompatImageView {

    private WeakReference<Bitmap> mShape = new WeakReference<Bitmap>(null);
    private Xfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Paint paint;
    private int shapeResID;


    public ShapedImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        paint = new Paint(Paint.ANTI_ALIAS_FLAG);
        final TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.online_ShapedImageView);
        shapeResID = array.getResourceId(R.styleable.online_ShapedImageView_online_shape, 0);
        array.recycle();
    }

    public void setShapeResID(int shapeResID) {
        this.shapeResID = shapeResID;
        invalidate();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int sc = canvas.saveLayer(0, 0, getMeasuredWidth(), getMeasuredHeight(), null
                , Canvas.ALL_SAVE_FLAG);
        super.onDraw(canvas);
        if (shapeResID != 0) {
            Bitmap bitmap = mShape.get();
            if (bitmap == null) {
                bitmap = getShape();
                mShape = new WeakReference<>(bitmap);
            }
            paint.setXfermode(mode);
            canvas.drawBitmap(bitmap, 0, 0, paint);
            paint.setXfermode(null);
        }
        canvas.restoreToCount(sc);


    }

    private Bitmap getShape() {
        final Bitmap bitmap = BitmapFactory.decodeResource(getResources(), shapeResID);
        int newWidth = getMeasuredWidth();
        int newHeight = getMeasuredHeight();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = ((float) newWidth) / width;
        float scaleHeight = ((float) newHeight) / height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap(bitmap, 0, 0, width, height, matrix,
                true);
    }
}
