package com.ebaiyihui.module_bothreferral.decorate;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

import com.flyco.roundview.RoundFrameLayout;
import com.kangxin.common.R;

public class StripBarView extends LinearLayout {

    RoundFrameLayout bar1;

    RoundFrameLayout bar2;

    RoundFrameLayout bar3;

    TextView hint1;

    TextView hint2;

    public StripBarView(Context context) {
        super(context);
        init();
    }

    public StripBarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public StripBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {

        inflate(getContext(), R.layout.strip_bar_layout, this);

        bar1 = findViewById(R.id.bar1);
        bar2 = findViewById(R.id.bar2);
        bar3 = findViewById(R.id.bar3);

        hint1 = findViewById(R.id.hint1);
        hint2 = findViewById(R.id.hint2);

    }

    private void open(RoundFrameLayout... bars) {
        for (RoundFrameLayout item : bars) {
            item.getDelegate().setBackgroundColor(Color.WHITE);
        }
    }

    private void close(RoundFrameLayout... bars) {
        for (RoundFrameLayout item : bars) {
            item.getDelegate().setBackgroundColor(Color.parseColor("#333333"));
        }
    }

    public void setBarNum(int i) {

        if (i == 0) {
            close(bar1, bar2, bar3);
        }

        if (i == 1) {
            open(bar1);
            close(bar2, bar3);
        }

        if (i == 2) {
            open(bar1, bar2);
            close(bar3);
        }

        if (i == 3) {
            open(bar1, bar2, bar3);
        }

    }

    public void setHint(String hint1, String hint2) {
        this.hint1.setText(hint1);
        this.hint2.setText(hint2);
    }

}
