package com.kangxin.common.byh.base;


import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.kangxin.common.byh.callback.EmptyCallback;
import com.kangxin.common.byh.callback.ErrorCallback;
import com.kingja.loadsir.callback.Callback;
import com.kingja.loadsir.core.LoadService;
import com.kingja.loadsir.core.LoadSir;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public abstract class ByBaseStateFlushMoreFragment<T> extends BaseFlushMoreFragment<T> {


    private LoadService loadService;

    @Nullable
    @Override
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);

        loadService = LoadSir.getDefault().register(rootView, (Callback.OnReloadListener) v -> flushOrLoad(false));
        return loadService.getLoadLayout();
    }


    @Override
    public void addMore(List<T> pageData) {
        super.addMore(pageData);
        loadService.showSuccess();
    }

    @Override
    public void bindData(List<T> pageData) {
        super.bindData(pageData);
        loadService.showSuccess();
    }

    @Override
    public void noData() {
        super.noData();
        loadService.showCallback(EmptyCallback.class);
    }

    @Override
    public void error() {
        super.error();
        loadService.showCallback(ErrorCallback.class);
    }

    @Override
    public void error(@Nullable String errorMsg) {
        super.error(errorMsg);
        loadService.showCallback(ErrorCallback.class);
    }

}
