package com.kangxin.common.byh.progress;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.kangxin.common.R;


public class SVProgressDefaultView extends LinearLayout {
    private int resInfo;
    private int resSuccess;
    private int resError;
    private TextView tvMsg;
    private LoadingView mLoadingView;
    private ImageView mIv;
    private RotateAnimation mRotateAnimation;

    public SVProgressDefaultView(Context context) {
        super(context);
        this.resInfo = R.drawable.ic_svstatus_info;
        this.resSuccess = R.drawable.ic_svstatus_success;
        this.resError = R.drawable.ic_svstatus_error;
        this.initViews();
        this.init();
    }

    private void initViews() {
        LayoutInflater.from(this.getContext()).inflate(R.layout.view_svprogressdefault, this, true);
        this.setGravity(17);
        this.mLoadingView = (LoadingView) this.findViewById(R.id.loadingView);
        this.mIv = (ImageView) this.findViewById(R.id.ivSmallLoading);
        this.tvMsg = (TextView) this.findViewById(R.id.tvMsg);
    }

    private void init() {
        this.mRotateAnimation = new RotateAnimation(0.0F, 359.0F, 1, 0.5F, 1, 0.5F);
        this.mRotateAnimation.setDuration(1000L);
        this.mRotateAnimation.setInterpolator(new LinearInterpolator());
        this.mRotateAnimation.setRepeatCount(-1);
        this.mRotateAnimation.setRepeatMode(1);
    }

    public void showWithStatus(String string) {
        this.showBaseStatus(0, string);
    }

    public void showInfoWithStatus(String string) {
        this.showBaseStatus(this.resInfo, string);
    }

    public void showSuccessWithStatus(String string) {
        this.showBaseStatus(this.resSuccess, string);
    }

    public void showErrorWithStatus(final String string) {
        this.post(new Runnable() {
            public void run() {
                SVProgressDefaultView.this.showBaseStatus(SVProgressDefaultView.this.resError, string);
            }
        });
    }

    public void setText(String string) {
        this.tvMsg.setText(string);
    }

    public void showBaseStatus(int res, String string) {
        if (res == 0) {
            this.mLoadingView.setVisibility(View.VISIBLE);
            this.mIv.setVisibility(View.GONE);
        } else {
            this.mLoadingView.setVisibility(View.GONE);
            this.mIv.setVisibility(View.VISIBLE);
            this.mIv.setImageResource(res);
        }

        this.tvMsg.setText(string);
        this.tvMsg.setVisibility(View.VISIBLE);
    }
}

