package com.kangxin.common.imageshow;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.ViewPager;

import com.kangxin.common.R;

import java.util.List;

import me.yokeyword.fragmentation.SupportFragment;

public class ImgListShowFragment extends SupportFragment {

    ViewPager mVp;

    List<String> urlList;
    private int defaultPos;

    public ImgListShowFragment(List<String> urlList) {
        this.urlList = urlList;
    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.common_imgshow, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mVp = view.findViewById(R.id.parent);
        PhotoViewAdapter adapter = new PhotoViewAdapter(urlList);
        mVp.setAdapter(adapter);

        mVp.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

            }

            @Override
            public void onPageSelected(int position) {

            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        mVp.setCurrentItem(defaultPos);
    }

    public void setDefaultIndext(int position) {
        defaultPos = position;
    }

}
