package com.kangxin.common.widget.adapter;

import android.view.View;

import com.chad.library.adapter.base.BaseMultiItemQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.chad.library.adapter.base.entity.MultiItemEntity;

import java.util.ArrayList;
import java.util.List;

public abstract class ImageAddDeleteRecyclerViewAdapter extends BaseMultiItemQuickAdapter<ImageAddDeleteRecyclerViewAdapter.ImageAddDeleteEntity, ImageAddDeleteRecyclerViewAdapter.ImageAddDeleteViewHolder> {


    private boolean isShowFooter = false;

    /**
     * Same as QuickAdapter#QuickAdapter(Context,int) but with
     * some initialization data.
     *
     * @param data A new list is created out of this one to avoid mutable list
     */
    public ImageAddDeleteRecyclerViewAdapter(List<String> data) {
        super(parse(data));
        addItemType(ImageAddDeleteEntity.FOOTER, getFootLayoutId());
        addItemType(ImageAddDeleteEntity.ITEM, getItemLayoutId());
    }

    public static List<ImageAddDeleteEntity> parse(List<String> data) {
        List<ImageAddDeleteEntity> imageAddDeleteEntities = new ArrayList<>();
        if (data != null) {
            for (String temp : data) {
                imageAddDeleteEntities.add(new ImageAddDeleteEntity(temp));
            }
        }

        return imageAddDeleteEntities;
    }

    @Override
    protected ImageAddDeleteViewHolder createBaseViewHolder(View view) {
        return new ImageAddDeleteViewHolder(view);
    }

    /**
     * 获取itemlayout
     *
     * @return
     */
    public abstract int getItemLayoutId();

    /**
     * 获取footlayout
     *
     * @return
     */
    public abstract int getFootLayoutId();

    @Override
    protected void convert(ImageAddDeleteViewHolder helper, ImageAddDeleteEntity item) {
        if (item.getItemType() == ImageAddDeleteEntity.FOOTER) {
            //尾部
        } else {
            //展示item
            fullItem(helper, item);
        }
    }

    protected abstract void fullItem(ImageAddDeleteViewHolder itemView, ImageAddDeleteEntity item);


    /**
     * 展示尾部添加按钮图片
     */
    public void showAddImage() {
        getData().add(new ImageAddDeleteEntity(""));
    }

    public void hideAddImage() {
        getData().remove(getData().size() - 1);
    }

    public void addImageData(List<String> data) {
        List<ImageAddDeleteEntity> imageAddDeleteEntities = new ArrayList<>();
        for (String temp : data) {
            imageAddDeleteEntities.add(new ImageAddDeleteEntity(temp));
        }
        hideAddImage();
        addData(imageAddDeleteEntities);
        showAddImage();
    }


    public static class ImageAddDeleteEntity implements MultiItemEntity {

        static final int FOOTER = 1;
        static final int ITEM = 0;
        public String imageUrl = "";

        public ImageAddDeleteEntity(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @Override
        public int getItemType() {
            return imageUrl.equals("") ? 1 : 0;
        }
    }

    public class ImageAddDeleteViewHolder extends BaseViewHolder {
        public ImageAddDeleteViewHolder(View view) {
            super(view);
        }
    }
}
