/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.kangxin.common.R;

public class ClickNextItem
extends RelativeLayout {
    private TextView mLabelNameView;
    private TextView mValueView;
    private ImageView mArrowView;
    private View mRightView;
    private ImageView mLeftIconView;

    public ClickNextItem(Context context) {
        this(context, null);
    }

    public ClickNextItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ClickNextItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View rootView = LayoutInflater.from((Context)context).inflate(R.layout.commbyh_click_next_item, (ViewGroup)this, false);
        this.addView(rootView);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ClickNextItem);
        String labelName = null;
        String value = null;
        int labelColor = Color.parseColor((String)"#666666");
        int valueColor = Color.parseColor((String)"#333333");
        boolean isShowArrow = true;
        int leftIcon = -1;
        if (typedArray != null) {
            labelName = typedArray.getString(R.styleable.ClickNextItem_label_name);
            value = typedArray.getString(R.styleable.ClickNextItem_value);
            isShowArrow = typedArray.getBoolean(R.styleable.ClickNextItem_isShowArrow, true);
            labelColor = typedArray.getColor(R.styleable.ClickNextItem_label_color_nextitem, Color.parseColor((String)"#666666"));
            valueColor = typedArray.getColor(R.styleable.ClickNextItem_value_color_nextitem, Color.parseColor((String)"#333333"));
            leftIcon = typedArray.getResourceId(R.styleable.ClickNextItem_lefticon_nextitem, -1);
            typedArray.recycle();
        }
        this.mLabelNameView = (TextView)this.findViewById(R.id.label_name_txt);
        this.mValueView = (TextView)this.findViewById(R.id.value_name);
        this.mArrowView = (ImageView)this.findViewById(R.id.right_arrow_img);
        this.mRightView = this.findViewById(R.id.value_layout);
        this.mLeftIconView = (ImageView)this.findViewById(R.id.left_icon);
        this.mLabelNameView.setTextColor(labelColor);
        this.mValueView.setTextColor(valueColor);
        if (leftIcon != -1) {
            this.mLeftIconView.setVisibility(0);
            this.mLeftIconView.setImageResource(leftIcon);
        }
        if (!TextUtils.isEmpty((CharSequence)labelName)) {
            this.mLabelNameView.setText((CharSequence)labelName);
        }
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.mValueView.setText((CharSequence)value);
        }
        if (isShowArrow) {
            this.mArrowView.setVisibility(0);
        } else {
            this.mArrowView.setVisibility(8);
        }
    }

    public void setOnRightValueListener(View.OnClickListener listener2) {
        if (this.mRightView != null) {
            this.mRightView.setOnClickListener(listener2);
        }
    }

    public void setLabelName(String labelName) {
        if (this.mLabelNameView != null) {
            this.mLabelNameView.setText((CharSequence)labelName);
        }
    }

    public void setArrowImg(@DrawableRes int resId) {
        if (this.mArrowView != null) {
            this.mArrowView.setImageResource(resId);
        }
    }

    public void setValue(String value) {
        if (this.mValueView != null) {
            this.mValueView.setText((CharSequence)value);
        }
    }

    public void setShowArrow(boolean isShow) {
        if (isShow) {
            this.mArrowView.setVisibility(0);
        } else {
            this.mArrowView.setVisibility(8);
        }
    }
}

