/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http.interceptor;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AddCookieInterceptor
implements Interceptor {
    private static final String COOKIE_PREF = "cookies_prefs";
    private Context mContext;

    public AddCookieInterceptor(Context context) {
        this.mContext = context;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        String cookie = this.getCookie(request.url().toString(), request.url().host());
        if (!TextUtils.isEmpty((CharSequence)cookie)) {
            builder.addHeader("Cookie", cookie);
        }
        return chain.proceed(builder.build());
    }

    private String getCookie(String url, String domain) {
        SharedPreferences sp = this.mContext.getSharedPreferences(COOKIE_PREF, 0);
        if (!TextUtils.isEmpty((CharSequence)url) && sp.contains(url) && !TextUtils.isEmpty((CharSequence)sp.getString(url, ""))) {
            return sp.getString(url, "");
        }
        if (!TextUtils.isEmpty((CharSequence)domain) && sp.contains(domain) && !TextUtils.isEmpty((CharSequence)sp.getString(domain, ""))) {
            return sp.getString(domain, "");
        }
        return null;
    }
}

