package com.byh.module.onlineoutser.im.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;

import java.io.File;

/**
 * Created by poetr on 17/9/8.
 */
public class LocalFileUtils {
    public static final String IMAGE_CACHA_DIR = "temp_image_cache";

    private static final String NORMAL = "normal"; //用户普通文件
    private static final String IMAGE = "image"; //用户图片文件
    private static final String VOICE = "voice"; //用户音频文件
    private static final String LOG = "log"; //用户音频文件

    /*
     * 用于存储可删除的缓存文件
     * */
    private static String getCacheDir(Context context) {
        boolean writable = isExternalStorageWritable();
        File cacheDir = null;
        if (writable) {
            cacheDir = context.getExternalCacheDir();
            if (cacheDir == null) {
                cacheDir = new File(Environment.getExternalStorageDirectory().getAbsolutePath()
                        + File.separator + "Android"
                        + File.separator + "data"
                        + File.separator + context.getPackageName()
                        + File.separator + "cache");
            }
        } else {
            cacheDir = new File(context.getCacheDir().getAbsolutePath());
        }
        if (!cacheDir.exists()) cacheDir.mkdirs();
        return cacheDir.getAbsolutePath();
    }

    /*
     * 用于存储用户普通文件
     * */
    public static String getNormalFileDir(Context context) {
        boolean writable = isExternalStorageWritable();
        File file;
        if (writable) {
            file = context.getExternalFilesDir(NORMAL);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath()
                        + File.separator + "Android"
                        + File.separator + "data"
                        + File.separator + context.getPackageName()
                        + File.separator + "files"
                        + File.separator + NORMAL);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + NORMAL);
        }
        if (!file.exists()) file.mkdirs();

        return file.getAbsolutePath();
    }

    /*
     * 用于存储用户图像文件
     * */
    public static String getImageFileDir(Context context) {
        boolean writable = isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(IMAGE);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath()
                        + File.separator + "Android"
                        + File.separator + "data"
                        + File.separator + context.getPackageName()
                        + File.separator + "files"
                        + File.separator + IMAGE);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + IMAGE);
        }
        if (!file.exists()) file.mkdirs();

        return file.getAbsolutePath();
    }

    /*
     * 用于存储用户音频文件
     * */
    public static String getVoiceFileDir(Context context) {
        boolean writable = isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(VOICE);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath()
                        + File.separator + "Android"
                        + File.separator + "data"
                        + File.separator + context.getPackageName()
                        + File.separator + "files"
                        + File.separator + VOICE);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + VOICE);
        }
        if (!file.exists()) file.mkdirs();

        return file.getAbsolutePath();
    }

    /*
     * 用于存储日志文件
     * */
    public static String getLogFileDir(Context context) {
        boolean writable = isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(LOG);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath()
                        + File.separator + "Android"
                        + File.separator + "data"
                        + File.separator + context.getPackageName()
                        + File.separator + "files"
                        + File.separator + LOG);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + LOG);
        }
        if (!file.exists()) file.mkdirs();

        return file.getAbsolutePath();
    }


    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        if (Environment.MEDIA_MOUNTED.equals(state)) {
            return true;
        }
        return false;
    }


    public static long getFolderSize(File file) {
        long size = 0;
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; i++) {
            if (fileList[i].isDirectory()) {
                size = size + getFolderSize(fileList[i]);
            } else {
                size = size + fileList[i].length();
            }
        }
        return size;
    }


    public static String getTempImageCacheDir(Context context) {
        String cacheDir = getCacheDir(context);
        File file = new File(cacheDir, IMAGE_CACHA_DIR);
        if (!file.exists()) file.mkdirs();
        return file.getAbsolutePath();
    }

    public static void deleteTempImage(Context contex) {
        String dir = getTempImageCacheDir(contex);
        if (!TextUtils.isEmpty(dir)) {
            File file = new File(dir);
            deleteDir(file);
        }
    }

    public static boolean deleteDir(File dir) {

        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; i++) {
                boolean success = deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
            }
        }
        // The directory is now empty so now it can be smoked
        return dir.delete();
    }
}
