package com.ebaiyihui.module_bothreferral.decorate;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.kangxin.common.R;


public class TransferStatuCardView extends FrameLayout {

    public TransferStatuCardView(@NonNull Context context) {
        super(context);
        init();
    }

    public TransferStatuCardView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public TransferStatuCardView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        inflate(getContext(), R.layout.transfer_status_card_layout, this);
    }

    public void setTurnIn() {
        findViewById(R.id.statusCard).setBackgroundColor(Color.parseColor("#3576E0"));
        ((TextView) findViewById(R.id.statusType)).setText(R.string.bothreferral_wodezhuanru);
    }

    public void setTurnOut() {
        findViewById(R.id.statusCard).setBackgroundColor(Color.parseColor("#FF5F5F"));
        ((TextView) findViewById(R.id.statusType)).setText(R.string.bothreferral_wodezhuanchu);
    }

}
