package com.kangxin.common.byh.activity;


import android.view.View;

import com.kangxin.common.R;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.util.GlideImageLoader;
import com.youth.banner.Banner;
import com.youth.banner.BannerConfig;
import com.youth.banner.Transformer;
import com.youth.banner.view.BannerViewPager;

import java.lang.reflect.Field;
import java.util.List;

/**
 * 浏览大图
 */
public class MulitImageShowActivity extends BaseActivity {

    private static final String TAG = "MulitImageShowActivity";
    private Banner banner;

    private List<String> images;
    private int position;

    private void init() {

        banner = findViewById(R.id.banner);
        banner.setImageLoader(new GlideImageLoader());
        banner.setImages(images);
        banner.setBannerAnimation(Transformer.DepthPage);
        banner.setIndicatorGravity(BannerConfig.CENTER);
        banner.setBannerStyle(BannerConfig.NUM_INDICATOR);
        banner.isAutoPlay(false);
        banner.start();
        findViewById(R.id.mBackBtn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        try {
            Object object = getValue(banner, "viewPager");
            if (object instanceof BannerViewPager) {
                ((BannerViewPager) object).setCurrentItem(position + 1);
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true); // 参数值为true，禁止访问控制检查
        return field.get(instance);
    }

    @Override
    public void start() {
        //展示的图片数组
        images = getIntent().getStringArrayListExtra("images");

        //位置
        position = getIntent().getIntExtra("position", 0);

        init();
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.mulit_image_show;
    }
}
