package com.kangxin.common.byh.progress;

import android.content.Context;

public class SVProgress {
    private SVProgressHUD svProgressHUD;

    public SVProgress(Context context) {
        this.svProgressHUD = new SVProgressHUD(context);
    }

    public SVProgressHUD getSvProgressHUD() {
        return this.svProgressHUD;
    }

    public void showLoading(String text) {
        if (this.svProgressHUD.isShowing()) {
            this.svProgressHUD.setText(text);
        } else {
            this.svProgressHUD.showWithStatus(text, SVProgressHUD.SVProgressHUDMaskType.Clear);
        }
    }

    public void showSuccess(String text) {
        this.svProgressHUD.showSuccessWithStatus(text, SVProgressHUD.SVProgressHUDMaskType.Clear);
    }

    public void showError(String text) {
        this.svProgressHUD.showErrorWithStatus(text, SVProgressHUD.SVProgressHUDMaskType.Clear);
    }

    public void showHit(String text) {
        this.svProgressHUD.showInfoWithStatus(text, SVProgressHUD.SVProgressHUDMaskType.Clear);
    }

    public boolean isShowing() {
        return this.svProgressHUD.isShowing();
    }

    public void dismiss() {
        if (this.isShowing()) {
            this.svProgressHUD.dismiss();
        }

    }
}
