package com.kangxin.common.byh.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.AsyncTask;
import android.widget.ImageView;

import cn.bingoogolapple.qrcode.zxing.QRCodeEncoder;


/**
 * 二维码工具类
 */
public class QRCodeUtil {

    /**
     * 生成二维码
     *
     * @param resId
     * @param content
     * @param size
     * @return
     */
    public static void bindQrImage(Context context, Integer resId, String content, int size, ImageView targetView) {
        Bitmap centerImage = null;
        // 二维码中间图标
        if (resId != null) {
            centerImage = BitmapFactory.decodeResource(context.getResources(), resId);
        }


        Bitmap finalCenterImage = centerImage;
        new AsyncTask<Void, Void, Bitmap>() {
            @Override
            protected Bitmap doInBackground(Void... params) {
                return QRCodeEncoder.syncEncodeQRCode(content, size, Color.BLACK, finalCenterImage);
            }

            @Override
            protected void onPostExecute(Bitmap bitmap) {
                if (bitmap != null) {
                    targetView.setImageBitmap(bitmap);
                } else {

                }
            }
        }.execute();

    }
}
