package com.kangxin.common.byh.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.kangxin.common.R;


public class HoriInfoItemView extends RelativeLayout {
    private TextView mLabelNameView;
    private TextView mValueView;

    public HoriInfoItemView(Context context) {
        this(context, null);
    }

    public HoriInfoItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public HoriInfoItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View rootView = LayoutInflater.from(context).inflate(R.layout.commbyh_hori_info_item, this, false);
        addView(rootView);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.HoriInfoItemView);
        String labelName = null;
        String value = null;

        int labelColor = Color.parseColor("#666666");
        int valueColor = Color.parseColor("#333333");


        if (typedArray != null) {
            labelName = typedArray.getString(R.styleable.HoriInfoItemView_label_name_infoitem);
            value = typedArray.getString(R.styleable.HoriInfoItemView_value_horinfoitem);
            labelColor = typedArray.getColor(R.styleable.HoriInfoItemView_label_color_infoitem, Color.parseColor("#666666"));
            valueColor = typedArray.getColor(R.styleable.HoriInfoItemView_value_color_infoitem, Color.parseColor("#333333"));
            typedArray.recycle();
        }

        mLabelNameView = findViewById(R.id.label_txt);
        mValueView = findViewById(R.id.value_txt);
        if (!TextUtils.isEmpty(labelName)) {
            mLabelNameView.setText(labelName);
        }


        if (!TextUtils.isEmpty(value)) {
            mValueView.setText(value);
        }


        mLabelNameView.setTextColor(labelColor);
        mValueView.setTextColor(valueColor);

    }

    public void setLabelName(String labelName) {
        if (mLabelNameView != null) {
            mLabelNameView.setText(labelName);
        }
    }

    public void setValue(String value) {
        if (mValueView != null) {
            mValueView.setText(value);
        }
    }
}
