package com.kangxin.common.byh.widget;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.LinearLayoutCompat;

import com.blankj.utilcode.util.SizeUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

import org.joda.time.DateTime;
import org.joda.time.LocalDate;

import java.util.ArrayList;
import java.util.List;

import static android.view.ViewGroup.LayoutParams.MATCH_PARENT;
import static android.view.ViewGroup.LayoutParams.WRAP_CONTENT;

public class SubscribeTimeCandlerView extends LinearLayoutCompat {

    int year = 2019;
    int month = 5;
    int day = 25;
    private String[] weeks = {StringsUtils.getString(R.string.commbyh_zhouyi), StringsUtils.getString(R.string.commbyh_zhouer), StringsUtils.getString(R.string.commbyh_zhousan), StringsUtils.getString(R.string.commbyh_zhousi), StringsUtils.getString(R.string.commbyh_zhouwu), StringsUtils.getString(R.string.commbyh_zhouliu), StringsUtils.getString(R.string.commbyh_zhouri)};
    private OnTimeClickListener listener;
    //期望展示的数量
    private int contentCount = 14;
    private List<CalendarEntity> contentResult;
    private DateSubView currentSelectDateView = null;
    //日历
    private DateTime currentDateTime;

    public SubscribeTimeCandlerView(Context context) {
        this(context, null);
    }

    public SubscribeTimeCandlerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SubscribeTimeCandlerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView() {
        setOrientation(LinearLayoutCompat.VERTICAL);

        year = LocalDate.now().getYear();
        month = LocalDate.now().getMonthOfYear();
        day = LocalDate.now().getDayOfMonth();
        currentDateTime = new DateTime(year, month, day, 0, 0);

        initDateTime();
        //时间绑定到view
        //每行展示7个
        //添加星期控件

        View weekView = initWeeks();
        addView(weekView, new LinearLayout.LayoutParams(MATCH_PARENT, WRAP_CONTENT));

        for (int i = 0; i < 3; i++) {
            DateSubLinearlayout dateSubLinearlayout = new DateSubLinearlayout(getContext());
            dateSubLinearlayout.setLayoutParams(new LayoutParams(MATCH_PARENT, WRAP_CONTENT));
            inflateSubView(dateSubLinearlayout, i);
            addView(dateSubLinearlayout, new LayoutParams(MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
            View view = new View(getContext());
            view.setLayoutParams(new LinearLayout.LayoutParams(MATCH_PARENT, SizeUtils.dp2px(1)));
            view.setBackgroundColor(Color.rgb(235, 235, 235));
            addView(view, new LinearLayout.LayoutParams(MATCH_PARENT, SizeUtils.dp2px(1)));
        }
    }

    private View initWeeks() {

        LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(getContext());
        for (int i = 0; i < 7; i++) {
            TextView textView = new TextView(getContext());
            textView.setText(weeks[i]);
            textView.setGravity(Gravity.CENTER);
            textView.setTextColor(Color.BLACK);
            textView.setPadding(0, SizeUtils.dp2px(5), 0, SizeUtils.dp2px(10));
            textView.setLayoutParams(new LinearLayout.LayoutParams(SizeUtils.dp2px(48), WRAP_CONTENT, 1));
            linearLayoutCompat.addView(textView, new LinearLayout.LayoutParams(SizeUtils.dp2px(50), WRAP_CONTENT, 1));
        }
        return linearLayoutCompat;
    }

    private void inflateSubView(DateSubLinearlayout dateSubLinearlayout, int index) {
        int count = index * 7 + 7;
        for (int i = 7 * index; i < count; i++) {

            if (i >= contentResult.size()) {
                break;
            }

            DateSubView dateSubView = new DateSubView(getContext(), contentResult.get(i));
            dateSubView.setLayoutParams(new LayoutParams(SizeUtils.dp2px(40), SizeUtils.dp2px(30), 1));
            dateSubView.setGravity(Gravity.CENTER);
            dateSubView.setOnClickListener(new OnClickListener() {
                @Override
                public void onClick(View v) {
                    int year = dateSubView.getDateTime().getYear();
                    int month = dateSubView.getDateTime().getMonthOfYear();
                    int day = dateSubView.getDateTime().getDayOfMonth();
                    if (listener != null) {
                        listener.onClick(year, month, day);
                        //原本的改变为灰色
                        currentSelectDateView.setTextColor(Color.BLACK);
                        //现在的改变为红色
                        dateSubView.setTextColor(getResources().getColor(R.color.colorPrimary));
                        currentSelectDateView = dateSubView;
                    }
                }
            });
            DateSubSubView dateSubSubView = new DateSubSubView(getContext(), contentResult.get(i));
            LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(getContext());
            linearLayoutCompat.setOrientation(VERTICAL);
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(MATCH_PARENT, WRAP_CONTENT);
            linearLayoutCompat.setLayoutParams(layoutParams);
            linearLayoutCompat.addView(dateSubView, new LayoutParams(SizeUtils.dp2px(40), SizeUtils.dp2px(60), 1));
            linearLayoutCompat.addView(dateSubSubView, new LayoutParams(SizeUtils.dp2px(40), SizeUtils.dp2px(60), 1));
            dateSubLinearlayout.addView(linearLayoutCompat, new LayoutParams(SizeUtils.dp2px(40), SizeUtils.dp2px(60), 1));
//            dateSubLinearlayout.addView();
        }
    }

    //计算需要展示的数据信息
    private void initDateTime() {
        contentResult = new ArrayList<>();
        int dayOfWeek = currentDateTime.getDayOfWeek();
        if (dayOfWeek <= 7) {
            for (int i = dayOfWeek - 1; i >= 0; i--) {
                contentResult.add(new CalendarEntity(currentDateTime.plusDays(-1 * i)));
            }
        }
        for (int i = 1; i < contentCount; i++) {
            contentResult.add(new CalendarEntity(currentDateTime.plusDays(i)));
        }


        CalendarEntity lastDateTime = contentResult.get(contentResult.size() - 1);
        int lastDayOfWeek = lastDateTime.getDateTime().getDayOfWeek();

        for (int i = 1; i <= 7 - lastDayOfWeek; i++) {
            contentResult.add(new CalendarEntity(lastDateTime.dateTime.plusDays(i)));
        }
        for (int i = 0; i < contentResult.size(); i++) {
            System.out.println("i == " + contentResult.get(i).getDateTime().getDayOfMonth());
        }

    }

    public void setListener(OnTimeClickListener listener) {
        this.listener = listener;
    }

    public interface OnTimeClickListener {
        void onClick(int year, int month, int day);
    }

    /**
     * 日历中的每个小方块
     */
    class DateSubLinearlayout extends LinearLayoutCompat {

        public DateSubLinearlayout(Context context) {
            super(context);
            setOrientation(HORIZONTAL);
        }
    }

    class DateSubSubView extends AppCompatTextView {

        private CalendarEntity entity;

        public DateSubSubView(Context context, CalendarEntity entity) {
            super(context);
            this.entity = entity;
            setGravity(Gravity.CENTER);

            if (currentDateTime.getYear() == entity.getDateTime().getYear() &&
                    currentDateTime.getMonthOfYear() == entity.getDateTime().getMonthOfYear() &&
                    currentDateTime.getDayOfMonth() == entity.getDateTime().getDayOfMonth()
            ) {
                setText(StringsUtils.getString(R.string.commbyh_jinri));
            }

            if ((entity.getDateTime().getMonthOfYear() > currentDateTime.getMonthOfYear()) && entity.getDateTime().getDayOfMonth() == 1) {
                setText(entity.getDateTime().getMonthOfYear() + StringsUtils.getString(R.string.commbyh_yue));
            }

        }
    }

    /**
     * 日历每个小方块需要展示的数据，该对象要添加到DateSubLinearlayout布局中才可以显示
     */
    class DateSubView extends AppCompatTextView {

        CalendarEntity entity;

        public DateSubView(Context context, CalendarEntity entity) {
            super(context);
            this.entity = entity;
            setGravity(TEXT_ALIGNMENT_CENTER);
            setText(entity.getDateTime().getDayOfMonth() + "");
            if (isSelectable()) {
                setTextColor(Color.BLACK);
                setClickable(true);
            } else {
                setTextColor(Color.GRAY);
                setClickable(false);
                setEnabled(false);
                setFocusable(false);
            }

            if (currentDateTime.getYear() == entity.getDateTime().getYear() &&
                    currentDateTime.getMonthOfYear() == entity.getDateTime().getMonthOfYear() &&
                    currentDateTime.getDayOfMonth() == entity.getDateTime().getDayOfMonth()
            ) {
                currentSelectDateView = this;
            }

        }


        public DateTime getDateTime() {
            return entity.dateTime;
        }


        /**
         * 是否可选
         *
         * @return
         */
        private boolean isSelectable() {

            System.out.println(StringsUtils.getString(R.string.commbyh_xiaoyudeshijian) + (entity.getDateTime().getMillis() < currentDateTime.getMillis()));
            System.out.println(StringsUtils.getString(R.string.commbyh_dayudeshijian) + (entity.getDateTime().getMillis() > currentDateTime.plusDays(contentCount).getMillis()));


            if (entity.getDateTime().getMillis() < currentDateTime.getMillis() || entity.getDateTime().getMillis() > currentDateTime.plusDays(contentCount).getMillis()) {
                return false;
            } else {
                return true;
            }
        }


    }

    /**
     * 日历实体
     */
    class CalendarEntity {

        DateTime dateTime;

        public CalendarEntity(DateTime dateTime) {
            this.dateTime = dateTime;
        }

        public DateTime getDateTime() {
            return dateTime;
        }

        public String getSubTitle() {
            return "";
        }
    }


}
