package com.kangxin.common.http.interceptor;


import androidx.annotation.NonNull;

import java.io.IOException;

import okhttp3.Response;

public class Interceptor implements okhttp3.Interceptor, Comparable<Interceptor> {

    okhttp3.Interceptor interceptor;

    int level;

    public Interceptor(okhttp3.Interceptor interceptor, int level) {
        this.interceptor = interceptor;
        this.level = level;
    }

    public okhttp3.Interceptor getInterceptor() {
        return interceptor;
    }

    public void setInterceptor(okhttp3.Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public int getLevel() {
        return level;
    }

    public void setLevel(int level) {
        this.level = level;
    }


    @Override
    public Response intercept(Chain chain) throws IOException {
        return null;
    }


    @Override
    public int compareTo(@NonNull Interceptor interceptor) {
        return this.getLevel() - interceptor.getLevel();
    }
}
