package com.kangxin.common.util;

import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.util.Log;
import android.view.Gravity;
import android.view.Window;
import android.view.WindowManager;

import com.kangxin.common.R;


public class LoadingUtil {
    private static Dialog loadingDialog;


    public static void showLoadingDialog(final Activity activity) {
        if (loadingDialog == null || !loadingDialog.isShowing()) {
            loadingDialog = new Dialog(activity, R.style.MyDialogStyle);
            loadingDialog.setContentView(R.layout.activity_net_loading);
//            loadingDialog.setCanceledOnTouchOutside(true);

            /**
             *将显示Dialog的方法封装在这里面
             */
            Window window = loadingDialog.getWindow();
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.width = WindowManager.LayoutParams.MATCH_PARENT;
            lp.height = WindowManager.LayoutParams.WRAP_CONTENT;
            window.setGravity(Gravity.CENTER);
            window.setAttributes(lp);
            window.setWindowAnimations(R.style.PopWindowAnimStyle);

            loadingDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
                @Override
                public void onDismiss(DialogInterface dialog) {
                    clossLoadingActivity();
                }
            });
            try {
                loadingDialog.show();
            } catch (Exception e) {
                Log.d("崩溃时候走这个方法了吗", e.getMessage());
                clossLoadingActivity();
            }

        }
    }

    public static void clossLoadingActivity() {
        if (loadingDialog != null) {
            if (loadingDialog.isShowing()) {
                loadingDialog.dismiss();
            }
            loadingDialog = null;
        }
    }
}
