package com.kangxin.common.widget;

import android.content.Context;

import com.kangxin.common.util.GlobeLoadingHelper;

import io.reactivex.observers.DefaultObserver;

public abstract class ProgressDialogObserver<T> extends DefaultObserver<T> {

    private static final String TAG = "ProgressDialogObserver";

    //上下文
    private Context mContext;

    public ProgressDialogObserver() {
        super();
        mContext = attachContext();
    }

    @Override
    protected void onStart() {
        GlobeLoadingHelper.show(mContext);
    }

    @Override
    public abstract void onNext(T t);

    @Override
    public void onError(Throwable t) {
        t.printStackTrace();
        GlobeLoadingHelper.dissmiss();
    }

    @Override
    public void onComplete() {
        GlobeLoadingHelper.dissmiss();
    }

    protected abstract Context attachContext();

}
