/*
 * Decompiled with CFR 0.152.
 */
package com.byh.lib.byhim.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import com.kangxin.common.R;
import com.kangxin.common.util.StringUtil;

public class MessageItem
extends RelativeLayout {
    public static final int POINT_VISIBLE = 0;
    public static final int POINT_UNVISIBLE = 8;
    private Context mContext;
    private ImageView mLeftIconImageView;
    private TextView mNameTextView;
    private TextView mContentTextView;
    private TextView mTimeTextView;
    private TextView mPointTextView;

    public MessageItem(Context context) {
        this(context, null);
    }

    public MessageItem(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MessageItem(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initViews(attrs);
    }

    private void initViews(AttributeSet attrs) {
        MessageItem.inflate((Context)this.mContext, (int)R.layout.im_msg_item, (ViewGroup)this);
        this.mLeftIconImageView = (ImageView)this.findViewById(R.id.img_icon);
        this.mNameTextView = (TextView)this.findViewById(R.id.name_txt);
        this.mContentTextView = (TextView)this.findViewById(R.id.content_text);
        this.mPointTextView = (TextView)this.findViewById(R.id.point_txt);
        this.mTimeTextView = (TextView)this.findViewById(R.id.time_txt);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.MessageItem);
        int leftIcon = typedArray.getResourceId(R.styleable.MessageItem_msg_icon, 0);
        String name = typedArray.getString(R.styleable.MessageItem_msg_name);
        String content = typedArray.getString(R.styleable.MessageItem_msg_content);
        String msgTime = typedArray.getString(R.styleable.MessageItem_msg_time);
        int showPoint = typedArray.getIndex(R.styleable.MessageItem_show_point);
        typedArray.recycle();
        this.mContentTextView.setMaxLines(1);
        this.setIconRes(leftIcon);
        this.setName(name);
        this.setContent(content);
        this.setTime(msgTime);
        this.setPointVisible(showPoint);
    }

    public void setPointVisible(int visible) {
        if (visible == 0) {
            this.mPointTextView.setVisibility(0);
        } else if (visible == 8) {
            this.mPointTextView.setVisibility(8);
        }
    }

    public void setPointBg(@DrawableRes int res) {
        this.mPointTextView.setBackgroundResource(res);
    }

    public void setPointValue(String value) {
        this.mPointTextView.setText((CharSequence)value);
    }

    public void setTime(String time) {
        this.mTimeTextView.setText((CharSequence)time);
    }

    public void setContent(String content) {
        content = StringUtil.changeSubText(content, 15);
        this.mContentTextView.setText((CharSequence)content);
    }

    public void setIconRes(int id2) {
        this.mLeftIconImageView.setImageResource(id2);
    }

    public void setName(String name) {
        this.mNameTextView.setText((CharSequence)name);
    }
}

