/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.utils;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;

public class LocalFileUtils {
    public static final String IMAGE_CACHA_DIR = "temp_image_cache";
    private static final String NORMAL = "normal";
    private static final String IMAGE = "image";
    private static final String VOICE = "voice";
    private static final String LOG = "log";

    private static String getCacheDir(Context context) {
        boolean writable = LocalFileUtils.isExternalStorageWritable();
        File cacheDir = null;
        if (writable) {
            cacheDir = context.getExternalCacheDir();
            if (cacheDir == null) {
                cacheDir = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "cache");
            }
        } else {
            cacheDir = new File(context.getCacheDir().getAbsolutePath());
        }
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir.getAbsolutePath();
    }

    public static String getNormalFileDir(Context context) {
        File file;
        boolean writable = LocalFileUtils.isExternalStorageWritable();
        if (writable) {
            file = context.getExternalFilesDir(NORMAL);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "files" + File.separator + NORMAL);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + NORMAL);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static String getImageFileDir(Context context) {
        boolean writable = LocalFileUtils.isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(IMAGE);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "files" + File.separator + IMAGE);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + IMAGE);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static String getVoiceFileDir(Context context) {
        boolean writable = LocalFileUtils.isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(VOICE);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "files" + File.separator + VOICE);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + VOICE);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static String getLogFileDir(Context context) {
        boolean writable = LocalFileUtils.isExternalStorageWritable();
        File file = null;
        if (writable) {
            file = context.getExternalFilesDir(LOG);
            if (file == null) {
                file = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + "Android" + File.separator + "data" + File.separator + context.getPackageName() + File.separator + "files" + File.separator + LOG);
            }
        } else {
            file = new File(context.getFilesDir() + File.separator + LOG);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public static long getFolderSize(File file) {
        long size = 0L;
        File[] fileList = file.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].isDirectory()) {
                size += LocalFileUtils.getFolderSize(fileList[i]);
                continue;
            }
            size += fileList[i].length();
        }
        return size;
    }

    public static String getTempImageCacheDir(Context context) {
        String cacheDir = LocalFileUtils.getCacheDir(context);
        File file = new File(cacheDir, IMAGE_CACHA_DIR);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    public static void deleteTempImage(Context contex) {
        String dir = LocalFileUtils.getTempImageCacheDir(contex);
        if (!TextUtils.isEmpty((CharSequence)dir)) {
            File file = new File(dir);
            LocalFileUtils.deleteDir(file);
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = LocalFileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

