/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.utils;

import android.media.MediaPlayer;
import android.text.TextUtils;
import java.io.File;

public class MediaPlayUtils {
    private static final String TAG = "MediaPlayUtils";
    private static final int STATUS_ERROR = -1;
    private static final int STATUS_STOP = 0;
    private static final int STATUS_PLAYING = 1;
    private static final int STATUS_PAUSE = 2;
    private static MediaPlayUtils mInstance = null;
    private MediaPlayer mediaPlayer = new MediaPlayer();
    private OnVoicePlayCompletionListener mListener;
    private String urlPath = "";
    private int status = 0;
    private int currentPosition = -1;
    private boolean calling = false;

    public MediaPlayUtils() {
        this.setOnCompletionListener();
        this.setOnErrorListener();
    }

    public static synchronized MediaPlayUtils getInstance() {
        if (null == mInstance) {
            mInstance = new MediaPlayUtils();
        }
        return mInstance;
    }

    public static void checkStatus() {
        MediaPlayUtils instance = MediaPlayUtils.getInstance();
        if (instance.isPlaying()) {
            instance.stop();
        }
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    private void play(boolean isEarpiece, int seek) {
        int streamType = 3;
        if (TextUtils.isEmpty((CharSequence)this.urlPath) || !new File(this.urlPath).exists()) {
            return;
        }
        if (isEarpiece) {
            streamType = 0;
        }
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
            this.setOnCompletionListener();
            this.setOnErrorListener();
        }
        try {
            this.mediaPlayer.reset();
            this.mediaPlayer.setAudioStreamType(streamType);
            this.mediaPlayer.setDataSource(this.urlPath);
            this.mediaPlayer.prepare();
            if (seek > 0) {
                this.mediaPlayer.seekTo(seek);
            }
            this.mediaPlayer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean play(String urlPath, boolean isEarpiece, int seek) {
        if (this.status != 0) {
            return false;
        }
        this.urlPath = urlPath;
        boolean result = false;
        try {
            this.play(isEarpiece, seek);
            this.status = 1;
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.play(true, seek);
                result = true;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                result = false;
            }
        }
        return result;
    }

    public boolean playVoice(String urlPath, boolean isEarpiece) {
        return this.play(urlPath, isEarpiece, 0);
    }

    public boolean resume() {
        if (this.status != 2) {
            return false;
        }
        boolean result = false;
        try {
            this.mediaPlayer.start();
            this.status = 1;
            result = true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.status = -1;
            result = false;
        }
        return result;
    }

    public boolean stop() {
        if (this.status != 1 && this.status != 2) {
            return false;
        }
        boolean result = false;
        try {
            if (this.mediaPlayer != null) {
                this.mediaPlayer.stop();
                this.mediaPlayer.release();
                this.mediaPlayer = null;
            }
            this.status = 0;
            result = true;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            this.status = -1;
            result = false;
        }
        return result;
    }

    public void setSpeakerOn(boolean speakerOn) {
        if (this.mediaPlayer == null) {
            this.mediaPlayer = new MediaPlayer();
        }
        if (!this.calling) {
            int currentPosition = this.mediaPlayer.getCurrentPosition();
            this.stop();
            this.setOnCompletionListener();
            this.setOnErrorListener();
            this.play(this.urlPath, !speakerOn, currentPosition);
        }
    }

    public boolean pause() {
        if (this.status != 1) {
            return false;
        }
        boolean result = false;
        try {
            this.mediaPlayer.pause();
            this.status = 2;
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
            this.status = -1;
        }
        return result;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPlaying() {
        return this.status == 1;
    }

    private void setOnCompletionListener() {
        this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                MediaPlayUtils.this.status = 0;
                if (MediaPlayUtils.this.mListener != null) {
                    MediaPlayUtils.this.mListener.OnVoicePlayCompletion();
                }
            }
        });
    }

    private void setOnErrorListener() {
        this.mediaPlayer.setOnErrorListener(null);
    }

    public void setOnVoicePlayCompletionListener(OnVoicePlayCompletionListener l) {
        this.mListener = l;
    }

    public static interface OnVoicePlayCompletionListener {
        public void OnVoicePlayCompletion();
    }
}

