/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaMetadataRetriever;
import android.media.MediaRecorder;
import android.media.ToneGenerator;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.Vibrator;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.FragmentActivity;
import com.byh.module.onlineoutser.im.utils.LocalFileUtils;
import com.byh.module.onlineoutser.im.utils.MediaPlayUtils;
import com.byh.module.onlineoutser.im.utils.UiUtil;
import com.byh.module.onlineoutser.im.utils.permissions.Permission;
import com.byh.module.onlineoutser.im.utils.permissions.RxPermissions2;
import com.byh.module.onlineoutser.im.view.RecordPopupWindow;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import io.reactivex.functions.Consumer;
import java.io.File;

public class RecordAudioUtils
implements MediaRecorder.OnInfoListener,
Handler.Callback {
    private static final String TAG = "RecordAudioUtils";
    private static final int TONE_LENGTH_MS = 200;
    private static final float TONE_RELATIVE_VOLUME = 100.0f;
    private static final int MAX_DURATION = 60;
    private View mAnchor;
    private RecordPopupWindow mPopupWindow;
    private Context mContext;
    private float mDy;
    private ToneGenerator mToneGenerator;
    private Object mToneGeneratorLock = new Object();
    private MediaRecorder mRecorder = null;
    private Handler mHandler;
    private Runnable mUpdateVisualizer = new Runnable(){

        @Override
        public void run() {
            if (RecordAudioUtils.this.mRecorder == null) {
                return;
            }
            int ratio = RecordAudioUtils.this.mRecorder.getMaxAmplitude() / 600;
            int db = 0;
            if (ratio > 1) {
                db = (int)(20.0 * Math.log10(ratio));
            }
            RecordAudioUtils.this.mPopupWindow.displayAmplitude(db / 4);
            RecordAudioUtils.this.mHandler.postDelayed((Runnable)this, 150L);
        }
    };
    private File mFile;
    private boolean mTimeOut;
    private AudioRecordListener mListener;
    private HandlerThread mTimerThread;
    private Handler mTimerHandler;
    private long mLastEvent;
    private RxPermissions2 rxPermissions;
    private boolean isRequesting;
    private boolean enable = true;
    private AlertDialog mWarnDialog;

    private RecordAudioUtils(Context context, View anchor) {
        this.mAnchor = anchor;
        this.mContext = context;
        this.rxPermissions = new RxPermissions2((FragmentActivity)this.mContext);
        this.mPopupWindow = new RecordPopupWindow(View.inflate((Context)this.mContext, (int)R.layout.online_voice_rcd_hint_window2, null), -1, -2);
    }

    public static RecordAudioUtils with(Context context, View v) {
        return new RecordAudioUtils(context, v);
    }

    public static synchronized int getVoiceDuration(String path) {
        MediaMetadataRetriever mmr = new MediaMetadataRetriever();
        mmr.setDataSource(path);
        String durationStr = mmr.extractMetadata(9);
        if (durationStr == null) {
            return 0;
        }
        Log.i((String)TAG, (String)("getVoiceDuration: durationStr:" + durationStr));
        double v = Double.parseDouble(durationStr);
        if (v < 500.0) {
            return 0;
        }
        return (int)Math.round(v / 1000.0);
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void show() {
        this.mAnchor.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"CheckResult"})
            public boolean onTouch(View v, MotionEvent event) {
                if (!RecordAudioUtils.this.enable) {
                    if (event.getActionMasked() == 0) {
                        // empty if block
                    }
                    return true;
                }
                if (System.currentTimeMillis() - RecordAudioUtils.this.mLastEvent < 300L) {
                    return true;
                }
                if (!RecordAudioUtils.this.rxPermissions.isGranted("android.permission.RECORD_AUDIO")) {
                    if (RecordAudioUtils.this.isRequesting) {
                        return true;
                    }
                    RecordAudioUtils.this.isRequesting = true;
                    RecordAudioUtils.this.rxPermissions.requestEach("android.permission.RECORD_AUDIO").subscribe((Consumer)new Consumer<Permission>(){

                        public void accept(Permission permission2) throws Exception {
                            RecordAudioUtils.this.isRequesting = false;
                            if (!permission2.granted && !permission2.shouldShowRequestPermissionRationale) {
                                RecordAudioUtils.this.showPermissionAlert();
                            }
                        }
                    });
                    return true;
                }
                switch (event.getActionMasked()) {
                    case 0: {
                        MediaPlayUtils.checkStatus();
                        RecordAudioUtils.this.mDy = event.getRawY();
                        RecordAudioUtils.this.mPopupWindow.switchStatus(1);
                        RecordAudioUtils.this.readyOperation();
                        RecordAudioUtils.this.initMediaRecorder();
                        RecordAudioUtils.this.mPopupWindow.switchStatus(2);
                        RecordAudioUtils.this.mPopupWindow.showAtLocation(RecordAudioUtils.this.mAnchor, 17, 0, 0);
                        break;
                    }
                    case 2: {
                        if (RecordAudioUtils.this.mTimeOut) {
                            return true;
                        }
                        float y = event.getRawY();
                        if (RecordAudioUtils.this.mDy - y > (float)UiUtil.INSTANCE.dpToPx(20.0f)) {
                            RecordAudioUtils.this.mPopupWindow.switchStatus(3);
                            break;
                        }
                        RecordAudioUtils.this.mPopupWindow.switchStatus(2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        RecordAudioUtils.this.mLastEvent = System.currentTimeMillis();
                        if (RecordAudioUtils.this.mTimeOut || RecordAudioUtils.this.mFile == null) break;
                        RecordAudioUtils.this.stopRecord();
                        if (RecordAudioUtils.this.mFile.exists() && RecordAudioUtils.this.mFile.length() > 0L) {
                            if (RecordAudioUtils.this.mPopupWindow.getStatus() == 3) {
                                RecordAudioUtils.this.mFile.delete();
                                RecordAudioUtils.this.mPopupWindow.dismiss();
                                break;
                            }
                            int mill = RecordAudioUtils.getVoiceDuration(RecordAudioUtils.this.mFile.getAbsolutePath());
                            if (mill == 0) {
                                RecordAudioUtils.this.mFile.delete();
                                RecordAudioUtils.this.warning(4);
                                break;
                            }
                            RecordAudioUtils.this.complete();
                            RecordAudioUtils.this.mPopupWindow.dismiss();
                            break;
                        }
                        RecordAudioUtils.this.mFile.delete();
                        RecordAudioUtils.this.warning(4);
                    }
                }
                return true;
            }
        });
    }

    private void showPermissionAlert() {
        if (this.mWarnDialog == null) {
            this.mWarnDialog = new AlertDialog.Builder(this.mContext).setTitle((CharSequence)StringsUtils.getString(R.string.onlineoutser_wenxintishi)).setMessage((CharSequence)(StringsUtils.getString(R.string.onlineoutser_luyinquanxianjujue___) + StringsUtils.getString(R.string.onlineoutser_qingzai_shezhi_yingyongchengxu_huayitongyishengban_quanxian_shoudongdakailuyinquanxian_))).setNegativeButton((CharSequence)StringsUtils.getString(R.string.onlineoutser_quxiao), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setPositiveButton((CharSequence)StringsUtils.getString(R.string.onlineoutser_qudakai), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent();
                    intent.setAction("android.settings.APPLICATION_SETTINGS");
                    if (intent.resolveActivity(RecordAudioUtils.this.mContext.getPackageManager()) != null) {
                        RecordAudioUtils.this.mContext.startActivity(intent);
                    }
                    dialog.dismiss();
                }
            }).create();
        }
        if (!this.mWarnDialog.isShowing()) {
            this.mWarnDialog.show();
        }
    }

    public boolean isRecording() {
        return this.mPopupWindow.isShowing();
    }

    public void setAudioRecorderListener(AudioRecordListener listener2) {
        this.mListener = listener2;
    }

    private void complete() {
        if (this.mListener != null && this.mFile != null) {
            this.mListener.onAudioComplete(this.mFile.getAbsolutePath());
        }
    }

    private void warning(int status) {
        this.mPopupWindow.switchStatus(status);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                RecordAudioUtils.this.mPopupWindow.dismiss();
            }
        }, 1000L);
    }

    private synchronized void initMediaRecorder() {
        this.mFile = new File(LocalFileUtils.getVoiceFileDir(this.mContext) + File.separator + String.valueOf(System.currentTimeMillis()) + ".amr");
        if (this.mRecorder == null) {
            this.mRecorder = new MediaRecorder();
            this.mHandler = new Handler();
            this.mTimerThread = new HandlerThread("RecordTimer");
        }
        try {
            this.mRecorder.setAudioSource(1);
            this.mRecorder.setOutputFormat(0);
            this.mRecorder.setAudioEncoder(3);
            this.mRecorder.setOutputFile(this.mFile.getAbsolutePath());
            this.mRecorder.setMaxDuration(60000);
            this.mRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
            this.mRecorder.prepare();
            this.mRecorder.start();
        }
        catch (Exception e) {
            this.mRecorder = null;
            this.mPopupWindow.dismiss();
        }
        this.mTimerThread.start();
        this.mTimerHandler = new Handler(this.mTimerThread.getLooper(), (Handler.Callback)this);
        this.mTimerHandler.sendMessage(this.mTimerHandler.obtainMessage());
        this.mHandler.post(this.mUpdateVisualizer);
        this.mTimeOut = false;
        this.mAnchor.setKeepScreenOn(true);
    }

    private synchronized void stopRecord() {
        if (this.mRecorder != null) {
            try {
                this.mRecorder.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mRecorder.release();
            this.mRecorder = null;
            this.mHandler.removeCallbacks(this.mUpdateVisualizer);
            this.mTimerThread.quit();
            this.mTimerThread = null;
            this.mAnchor.setKeepScreenOn(false);
        }
    }

    private void readyOperation() {
        this.playTone(24, 200);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                RecordAudioUtils.this.stopTone();
            }
        }, 200L);
        this.vibrate(50L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playTone(int tone, int durationMs) {
        Object object = this.mToneGeneratorLock;
        synchronized (object) {
            this.initToneGenerator();
            if (this.mToneGenerator == null) {
                return;
            }
            this.mToneGenerator.startTone(tone, durationMs);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public synchronized void vibrate(long milliseconds) {
        Vibrator mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        if (mVibrator == null) {
            return;
        }
        mVibrator.vibrate(milliseconds);
    }

    public void stopTone() {
        if (this.mToneGenerator != null) {
            this.mToneGenerator.stopTone();
        }
    }

    private void initToneGenerator() {
        AudioManager mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        if (this.mToneGenerator == null) {
            try {
                int streamVolume = mAudioManager.getStreamVolume(3);
                int streamMaxVolume = mAudioManager.getStreamMaxVolume(3);
                int volume = (int)(100.0f * (float)(streamVolume / streamMaxVolume));
                this.mToneGenerator = new ToneGenerator(3, volume);
            }
            catch (RuntimeException e) {
                this.mToneGenerator = null;
            }
        }
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
        if (what == 800) {
            this.mTimeOut = true;
            this.stopRecord();
            this.mPopupWindow.dismiss();
            this.complete();
        }
    }

    public boolean handleMessage(Message msg) {
        if (!this.mFile.exists() || this.mFile.length() == 0L) {
            this.mTimerHandler.sendMessageDelayed(Message.obtain(), 1000L);
            return true;
        }
        int curr = RecordAudioUtils.getVoiceDuration(this.mFile.getAbsolutePath());
        final int rest = 60 - curr;
        if (rest <= 10) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (RecordAudioUtils.this.mPopupWindow.getStatus() == 2 || RecordAudioUtils.this.mPopupWindow.getStatus() == 5) {
                        RecordAudioUtils.this.mPopupWindow.switchStatus(5);
                        RecordAudioUtils.this.mPopupWindow.updateTick(rest);
                    }
                }
            });
        }
        if (rest > 0) {
            this.mTimerHandler.sendMessageDelayed(Message.obtain(), 1000L);
        }
        return true;
    }

    public static interface AudioRecordListener {
        public void onAudioComplete(String var1);
    }
}

