/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.utils.permissions;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.byh.module.onlineoutser.im.utils.permissions.Permission;
import com.byh.module.onlineoutser.im.utils.permissions.RxPermissionsFragment;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;

public class RxPermissions2 {
    static final String TAG = RxPermissions2.class.getSimpleName();
    static final Object TRIGGER = new Object();
    @VisibleForTesting
    Lazy<RxPermissionsFragment> mRxPermissionsFragment;

    public RxPermissions2(@NonNull FragmentActivity activity) {
        this.mRxPermissionsFragment = this.getLazySingleton(activity.getSupportFragmentManager());
    }

    public RxPermissions2(@NonNull Fragment fragment) {
        this.mRxPermissionsFragment = this.getLazySingleton(fragment.getChildFragmentManager());
    }

    @NonNull
    private Lazy<RxPermissionsFragment> getLazySingleton(final @NonNull FragmentManager fragmentManager) {
        return new Lazy<RxPermissionsFragment>(){
            private RxPermissionsFragment rxPermissionsFragment;

            @Override
            public synchronized RxPermissionsFragment get() {
                if (this.rxPermissionsFragment == null) {
                    this.rxPermissionsFragment = RxPermissions2.this.getRxPermissionsFragment(fragmentManager);
                }
                return this.rxPermissionsFragment;
            }
        };
    }

    private RxPermissionsFragment getRxPermissionsFragment(@NonNull FragmentManager fragmentManager) {
        boolean isNewInstance;
        RxPermissionsFragment rxPermissionsFragment = this.findRxPermissionsFragment(fragmentManager);
        boolean bl = isNewInstance = rxPermissionsFragment == null;
        if (isNewInstance) {
            rxPermissionsFragment = new RxPermissionsFragment();
            fragmentManager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitNow();
        }
        return rxPermissionsFragment;
    }

    private RxPermissionsFragment findRxPermissionsFragment(@NonNull FragmentManager fragmentManager) {
        return (RxPermissionsFragment)fragmentManager.findFragmentByTag(TAG);
    }

    public void setLogging(boolean logging) {
        this.mRxPermissionsFragment.get().setLogging(logging);
    }

    public <T> ObservableTransformer<T, Boolean> ensure(final String ... permissions) {
        return new ObservableTransformer<T, Boolean>(){

            public ObservableSource<Boolean> apply(Observable<T> o) {
                return RxPermissions2.this.request(o, permissions).buffer(permissions.length).flatMap((Function)new Function<List<Permission>, ObservableSource<Boolean>>(){

                    public ObservableSource<Boolean> apply(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        for (Permission p : permissions) {
                            if (p.granted) continue;
                            return Observable.just((Object)false);
                        }
                        return Observable.just((Object)true);
                    }
                });
            }
        };
    }

    public <T> ObservableTransformer<T, Permission> ensureEach(final String ... permissions) {
        return new ObservableTransformer<T, Permission>(){

            public ObservableSource<Permission> apply(Observable<T> o) {
                return RxPermissions2.this.request(o, permissions);
            }
        };
    }

    public <T> ObservableTransformer<T, Permission> ensureEachCombined(final String ... permissions) {
        return new ObservableTransformer<T, Permission>(){

            public ObservableSource<Permission> apply(Observable<T> o) {
                return RxPermissions2.this.request(o, permissions).buffer(permissions.length).flatMap((Function)new Function<List<Permission>, ObservableSource<Permission>>(){

                    public ObservableSource<Permission> apply(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        return Observable.just((Object)new Permission(permissions));
                    }
                });
            }
        };
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensureEach(permissions));
    }

    public Observable<Permission> requestEachCombined(String ... permissions) {
        return Observable.just((Object)TRIGGER).compose(this.ensureEachCombined(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions2.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap((Function)new Function<Object, Observable<Permission>>(){

            public Observable<Permission> apply(Object o) {
                return RxPermissions2.this.requestImplementation(permissions);
            }
        });
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mRxPermissionsFragment.get().containsByPermission(p)) continue;
            return Observable.empty();
        }
        return Observable.just((Object)TRIGGER);
    }

    private Observable<?> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just((Object)TRIGGER);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> requestImplementation(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            this.mRxPermissionsFragment.get().log("Requesting permission " + permission2);
            if (this.isGranted(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, true, false)));
                continue;
            }
            if (this.isRevoked(permission2)) {
                list.add(Observable.just((Object)new Permission(permission2, false, false)));
                continue;
            }
            PublishSubject subject = this.mRxPermissionsFragment.get().getSubjectByPermission(permission2);
            if (subject == null) {
                unrequestedPermissions.add(permission2);
                subject = PublishSubject.create();
                this.mRxPermissionsFragment.get().setSubjectForPermission(permission2, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        }
        return Observable.concat((ObservableSource)Observable.fromIterable(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!this.isMarshmallow()) {
            return Observable.just((Object)false);
        }
        return Observable.just((Object)this.shouldShowRequestPermissionRationaleImplementation(activity, permissions));
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationaleImplementation(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (this.isGranted(p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    void requestPermissionsFromFragment(String[] permissions) {
        this.mRxPermissionsFragment.get().log("requestPermissionsFromFragment " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        this.mRxPermissionsFragment.get().requestPermissions(permissions);
    }

    public boolean isGranted(String permission2) {
        return !this.isMarshmallow() || this.mRxPermissionsFragment.get().isGranted(permission2);
    }

    public boolean isRevoked(String permission2) {
        return this.isMarshmallow() && this.mRxPermissionsFragment.get().isRevoked(permission2);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.mRxPermissionsFragment.get().onRequestPermissionsResult(permissions, grantResults, new boolean[permissions.length]);
    }

    @FunctionalInterface
    public static interface Lazy<V> {
        public V get();
    }
}

