/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.AlphaAnimation;
import androidx.appcompat.widget.AppCompatTextView;
import com.kangxin.common.R;

public class CCPAnimImageView
extends AppCompatTextView {
    private static final int TYPE_VOICE_PLAYING = 1;
    private AlphaAnimation mAlphaAnimation;
    private AnimationDrawable mChattingFromAnimationDrawable;
    private AnimationDrawable mChattingToAnimationDrawable;
    private int mDuration = 300;
    private boolean isFrom = false;
    private boolean isRunning = false;

    public CCPAnimImageView(Context context) {
        super(context);
        this.initCCPAnimImageView();
    }

    public CCPAnimImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCCPAnimImageView();
    }

    public CCPAnimImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initCCPAnimImageView();
    }

    public void initCCPAnimImageView() {
        this.mAlphaAnimation = new AlphaAnimation(0.1f, 0.1f);
        this.mAlphaAnimation.setDuration(1000L);
        this.mAlphaAnimation.setRepeatCount(-1);
        this.mAlphaAnimation.setRepeatMode(2);
        this.mChattingFromAnimationDrawable = new AnimationDrawable();
        Drawable chattingFDrawale1 = this.getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f1);
        chattingFDrawale1.setBounds(0, 0, chattingFDrawale1.getIntrinsicWidth(), chattingFDrawale1.getIntrinsicHeight());
        this.mChattingFromAnimationDrawable.addFrame(chattingFDrawale1, this.mDuration);
        Drawable chattingFDrawale2 = this.getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f2);
        chattingFDrawale2.setBounds(0, 0, chattingFDrawale2.getIntrinsicWidth(), chattingFDrawale2.getIntrinsicHeight());
        this.mChattingFromAnimationDrawable.addFrame(chattingFDrawale2, this.mDuration);
        Drawable chattingFDrawale3 = this.getResources().getDrawable(R.drawable.online_chatfrom_voice_playing_f3);
        chattingFDrawale3.setBounds(0, 0, chattingFDrawale3.getIntrinsicWidth(), chattingFDrawale3.getIntrinsicHeight());
        this.mChattingFromAnimationDrawable.addFrame(chattingFDrawale3, this.mDuration);
        this.mChattingFromAnimationDrawable.setOneShot(false);
        this.mChattingFromAnimationDrawable.setVisible(true, true);
        this.mChattingToAnimationDrawable = new AnimationDrawable();
        Drawable chattingTDrawable_1 = this.getResources().getDrawable(R.drawable.online_chatto_voice_playing_f1);
        chattingTDrawable_1.setBounds(0, 0, chattingTDrawable_1.getIntrinsicWidth(), chattingTDrawable_1.getIntrinsicHeight());
        this.mChattingToAnimationDrawable.addFrame(chattingTDrawable_1, this.mDuration);
        Drawable chattingTDrawable_2 = this.getResources().getDrawable(R.drawable.online_chatto_voice_playing_f2);
        chattingTDrawable_2.setBounds(0, 0, chattingTDrawable_2.getIntrinsicWidth(), chattingTDrawable_2.getIntrinsicHeight());
        this.mChattingToAnimationDrawable.addFrame(chattingTDrawable_2, this.mDuration);
        Drawable chattingTDrawable_3 = this.getResources().getDrawable(R.drawable.online_chatto_voice_playing_f3);
        chattingTDrawable_3.setBounds(0, 0, chattingTDrawable_3.getIntrinsicWidth(), chattingTDrawable_3.getIntrinsicHeight());
        this.mChattingToAnimationDrawable.addFrame(chattingTDrawable_3, this.mDuration);
        this.mChattingToAnimationDrawable.setOneShot(false);
        this.mChattingToAnimationDrawable.setVisible(true, true);
        this.restBackground();
    }

    public void setDirection(boolean from) {
        this.isFrom = from;
        this.restBackground();
    }

    public final void startVoiceAnimation() {
        if (!this.isRunning) {
            this.isRunning = true;
            if (this.isFrom) {
                this.setCompoundDrawablesWithIntrinsicBounds((Drawable)this.mChattingFromAnimationDrawable, null, null, null);
                this.mChattingFromAnimationDrawable.stop();
                this.mChattingFromAnimationDrawable.start();
                return;
            }
            this.setCompoundDrawablesWithIntrinsicBounds(null, null, (Drawable)this.mChattingToAnimationDrawable, null);
            this.mChattingToAnimationDrawable.stop();
            this.mChattingToAnimationDrawable.start();
        }
    }

    public final void restBackground() {
        if (this.isFrom) {
            this.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.online_chatfrom_bg));
            this.setCompoundDrawablesWithIntrinsicBounds(0, 0, R.drawable.online_chatfrom_voice_playing, 0);
            return;
        }
        this.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.online_chatto_bg));
        this.setCompoundDrawablesWithIntrinsicBounds(R.drawable.online_chatto_voice_playing, 0, 0, 0);
    }

    public final void stopVoiceAnimation() {
        if (!this.isRunning) {
            return;
        }
        if (this.mAlphaAnimation != null && this.mAlphaAnimation.isInitialized()) {
            this.setAnimation(null);
        }
        this.isRunning = false;
        this.mChattingFromAnimationDrawable.stop();
        this.mChattingToAnimationDrawable.stop();
        this.restBackground();
    }
}

