/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;

public class MoveScaleView
extends LinearLayout {
    private int touchSlop;
    private boolean hasMovingLong = false;
    private View.OnClickListener clickListener;
    private boolean canMove;
    private float scaleRatio = 0.3f;
    private View parentView;
    private float defaultX = 0.0f;
    private float defaultY = 0.0f;
    private float lastX = 0.0f;
    private float lastY = 0.0f;

    public MoveScaleView(Context context) {
        this(context, null);
    }

    public MoveScaleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MoveScaleView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.setBackgroundColor(0);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.parentView == null) {
            this.parentView = (View)this.getParent();
        }
        if (!this.canMove) {
            return true;
        }
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    this.hasMovingLong = false;
                    this.defaultX = this.getX();
                    this.defaultY = this.getY();
                    this.lastX = event.getRawX();
                    this.lastY = event.getRawY();
                    break;
                }
                case 2: {
                    if (Math.abs(this.lastX - event.getRawX()) < (float)this.touchSlop && Math.abs(this.lastY - event.getRawY()) < (float)this.touchSlop) {
                        return true;
                    }
                    this.hasMovingLong = true;
                    this.setX(this.defaultX + event.getRawX() - this.lastX);
                    float toY = this.defaultY + event.getRawY() - this.lastY;
                    if (!(toY > 0.0f) || !(toY < (float)(this.parentView.getMeasuredHeight() - this.getMeasuredHeight()))) break;
                    this.setY(toY);
                    break;
                }
                case 1: {
                    if (!this.hasMovingLong && this.getDistance(this.defaultX - this.getX(), this.defaultY - this.getY()) < 3 && this.clickListener != null) {
                        this.clickListener.onClick((View)this);
                    }
                    this.autoSide();
                }
            }
        }
        return true;
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.clickListener = l;
    }

    public void closeMove() {
        this.canMove = false;
    }

    public void openMove() {
        this.canMove = true;
    }

    private int getDistance(float xDiff, float yDiff) {
        float all = (float)(Math.pow(xDiff, 2.0) + Math.pow(yDiff, 2.0));
        return (int)Math.sqrt(all);
    }

    public void setMax() {
        this.setX(0.0f);
        this.setY(0.0f);
        this.closeMove();
        View rootView = (View)this.getParent();
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = rootView.getMeasuredWidth();
        params.height = rootView.getMeasuredHeight();
        this.setLayoutParams(params);
    }

    public void setMin() {
        this.setX(0.0f);
        this.setY(0.0f);
        this.openMove();
        View rootView = (View)this.getParent();
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = (int)((float)rootView.getMeasuredWidth() * this.scaleRatio);
        params.height = (int)((float)rootView.getMeasuredHeight() * this.scaleRatio);
        this.setLayoutParams(params);
    }

    private void autoSide() {
        if (!this.canMove) {
            return;
        }
        View rootView = (View)this.getParent();
        float maxWidth = rootView.getMeasuredWidth();
        float preX = this.getX() > maxWidth / 2.0f ? maxWidth - (float)this.getMeasuredWidth() : 0.0f;
        ObjectAnimator.ofFloat((Object)((Object)this), (String)"translationX", (float[])new float[]{this.getX(), preX}).setDuration(300L).start();
    }
}

