/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Scroller;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class PullRecyclerView
extends LinearLayout
implements NestedScrollingParent {
    private NestedScrollingParentHelper helper = null;
    private MyRecyclerView myRecyclerView = null;
    private int mHeaderHeight = 0;
    private Scroller mScroller;
    private int mCurrent;
    private RefreshListener listener;
    private LoadMoreListener loadMoreListener;
    private boolean isRefreshing;
    private boolean isLoadingMore;
    private boolean nothingMore;

    public PullRecyclerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PullRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initView();
    }

    private void initView() {
        this.buildDefaultHeader();
        this.buildList();
        this.buildFooter();
    }

    private void buildFooter() {
        Context context = this.getContext();
        FrameLayout frameLayout = new FrameLayout(context);
        ProgressBar loading = new ProgressBar(context);
        loading.setPadding(0, (int)((float)this.mHeaderHeight * 0.2f), 0, (int)((float)this.mHeaderHeight * 0.2f));
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, this.mHeaderHeight);
        frameLayout.addView((View)loading, (ViewGroup.LayoutParams)params);
        TextView footer = new TextView(this.getContext());
        footer.setTextColor(-10066330);
        footer.setTextSize(13.0f);
        footer.setText((CharSequence)StringsUtils.getString(R.string.onlineoutser_yiwugengduo));
        footer.setGravity(17);
        FrameLayout.LayoutParams fp = new FrameLayout.LayoutParams(-1, this.mHeaderHeight);
        frameLayout.addView((View)footer, (ViewGroup.LayoutParams)fp);
        LinearLayout.LayoutParams pp = new LinearLayout.LayoutParams(-1, this.mHeaderHeight);
        pp.bottomMargin = -this.mHeaderHeight;
        this.addView((View)frameLayout, (ViewGroup.LayoutParams)pp);
        this.showLoadingMore(true);
    }

    private void showLoadingMore(boolean b) {
        ViewGroup p = (ViewGroup)this.getChildAt(2);
        if (b) {
            p.getChildAt(0).setVisibility(0);
            p.getChildAt(1).setVisibility(8);
        } else {
            p.getChildAt(0).setVisibility(8);
            p.getChildAt(1).setVisibility(0);
        }
    }

    private void buildList() {
        LinearLayout.LayoutParams ryp = new LinearLayout.LayoutParams(-1, 0);
        ryp.weight = 1.0f;
        this.addView((View)this.myRecyclerView, (ViewGroup.LayoutParams)ryp);
    }

    private void buildDefaultHeader() {
        ProgressBar defautHeader = new ProgressBar(this.getContext());
        defautHeader.setPadding(0, (int)((float)this.mHeaderHeight * 0.2f), 0, (int)((float)this.mHeaderHeight * 0.2f));
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, this.mHeaderHeight);
        params.topMargin = -this.mHeaderHeight;
        this.addView((View)defautHeader, (ViewGroup.LayoutParams)params);
    }

    private void init() {
        this.setOrientation(1);
        Context context = this.getContext();
        this.helper = new NestedScrollingParentHelper((ViewGroup)this);
        this.myRecyclerView = new MyRecyclerView(context);
        this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator(2.0f));
        this.mHeaderHeight = this.dpToPx(50.0f);
    }

    public void nothingMore(boolean b) {
        this.nothingMore = b;
        this.showLoadingMore(!b);
    }

    private int dpToPx(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setMyRecyclerView(RecyclerView.LayoutManager layoutManager, RecyclerView.Adapter adapter) {
        this.myRecyclerView.setMyLayoutManager(layoutManager);
        this.myRecyclerView.setAdapter(adapter);
    }

    public void setMyRecyclerView(RecyclerView.LayoutManager layoutManager, RecyclerView.Adapter adapter, boolean fixed) {
        this.myRecyclerView.setMyLayoutManager(layoutManager);
        this.myRecyclerView.setAdapter(adapter);
        this.myRecyclerView.setHasFixedSize(fixed);
    }

    public MyRecyclerView getMyRecyclerView() {
        return this.myRecyclerView;
    }

    public void addHeaderView(View headerView, int headerHeight) {
        View view;
        int count = this.getChildCount();
        if (count > 1 && !((view = this.getChildAt(0)) instanceof MyRecyclerView)) {
            this.removeViewAt(0);
        }
        this.mHeaderHeight = headerHeight;
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, headerHeight);
        layoutParams.topMargin = -headerHeight;
        headerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView(headerView, 0, (ViewGroup.LayoutParams)layoutParams);
    }

    public void setLoadMoreListener(LoadMoreListener loadMoreListener) {
        this.getChildAt(2).setVisibility(0);
        this.loadMoreListener = loadMoreListener;
    }

    public void setRefreshListener(RefreshListener listener2) {
        this.listener = listener2;
    }

    public void refreshComplete() {
        if (this.mCurrent < 0) {
            this.smoothScrollTo(-this.getCurr());
        }
        this.isRefreshing = false;
    }

    public void loadingMoreComplete() {
        if (this.mCurrent > 0) {
            this.smoothScrollTo(-this.getCurr());
        }
        this.isLoadingMore = false;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    private int getCurr() {
        return this.mCurrent;
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.helper.onNestedScrollAccepted(child, target, axes);
        this.mScroller.forceFinished(true);
        if (this.loadMoreListener != null && this.myRecyclerView.isFullScreen()) {
            this.getChildAt(2).setVisibility(0);
        } else {
            this.getChildAt(2).setVisibility(8);
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        if (dy > 0 && this.mCurrent < 0) {
            this.mCurrent += dy;
            if (this.mCurrent > 0) {
                consumed[1] = this.mCurrent;
                this.mCurrent = 0;
            } else {
                consumed[1] = dy;
            }
            this.scrollTo(0, this.getCurr());
        } else if (dy < 0 && this.mCurrent > 0) {
            this.mCurrent += dy;
            if (this.mCurrent < 0) {
                consumed[1] = this.mCurrent;
                this.mCurrent = 0;
            } else {
                consumed[1] = dy;
            }
            this.scrollTo(0, this.getCurr());
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.mCurrent += dyUnconsumed;
        this.scrollTo(0, this.getCurr());
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return false;
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public void onStopNestedScroll(View child) {
        this.helper.onStopNestedScroll(child);
        int d = -this.getCurr();
        if (this.listener != null && d >= this.mHeaderHeight) {
            this.smoothScrollTo(d - this.mHeaderHeight);
            if (!this.isRefreshing) {
                this.isRefreshing = true;
                this.listener.onRefresh();
            }
        } else if (d < 0 && this.loadMoreListener != null && this.myRecyclerView.isLastPosition() && -d >= this.mHeaderHeight) {
            this.smoothScrollTo(d + this.mHeaderHeight);
            if (!this.nothingMore && !this.isLoadingMore) {
                this.isLoadingMore = true;
                this.loadMoreListener.onLoadMore();
            }
        } else {
            this.smoothScrollTo(d);
        }
    }

    public int getNestedScrollAxes() {
        return this.helper.getNestedScrollAxes();
    }

    public void smoothScrollToPosition(int i) {
        this.myRecyclerView.smoothScrollToPosition(i);
    }

    public void listScrollBy(int y) {
        this.myRecyclerView.scrollBy(0, y);
    }

    public void scrollToPosition(int i) {
        this.myRecyclerView.scrollToPosition(i);
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int currY;
            this.mCurrent = currY = this.mScroller.getCurrY();
            this.scrollTo(0, currY);
            this.invalidate();
        }
    }

    private void smoothScrollTo(int distance) {
        this.mScroller.startScroll(0, this.getCurr(), 0, distance, 300);
        this.invalidate();
    }

    private void startScroll(int distance, int time) {
        this.mScroller.startScroll(0, this.getCurr(), 0, distance, time);
        this.invalidate();
    }

    public static class MyRecyclerView
    extends RecyclerView {
        private StaggeredGridLayoutManager staggeredGridLayoutManager = null;
        private LinearLayoutManager linearLayoutManager = null;
        private GridLayoutManager gridLayoutManager = null;

        public MyRecyclerView(Context context) {
            super(context);
            this.setVerticalFadingEdgeEnabled(false);
            this.setHorizontalFadingEdgeEnabled(false);
            this.setVerticalScrollBarEnabled(false);
            this.setHorizontalScrollBarEnabled(false);
            this.setOverScrollMode(2);
            this.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        }

        private void setMyLayoutManager(RecyclerView.LayoutManager layoutManager) {
            if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.staggeredGridLayoutManager = (StaggeredGridLayoutManager)layoutManager;
            } else if (layoutManager instanceof GridLayoutManager) {
                this.gridLayoutManager = (GridLayoutManager)layoutManager;
            } else if (layoutManager instanceof LinearLayoutManager) {
                this.linearLayoutManager = (LinearLayoutManager)layoutManager;
            }
            this.setLayoutManager(layoutManager);
            if (!this.isVertical()) {
                throw new NullPointerException("vertical!");
            }
        }

        public boolean isFirstPosition() {
            int firstVisibleItemPosition;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                firstVisibleItemPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] into = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(into);
                firstVisibleItemPosition = this.findMix(into);
            } else {
                firstVisibleItemPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            }
            return firstVisibleItemPosition <= 0;
        }

        public boolean isLastPosition() {
            int lastVisibleItemPosition;
            RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                lastVisibleItemPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                int[] into = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(into);
                lastVisibleItemPosition = this.findMax(into);
            } else {
                lastVisibleItemPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            }
            return lastVisibleItemPosition == layoutManager.getItemCount() - 1;
        }

        private int findMix(int[] firstPositions) {
            int min = firstPositions[0];
            for (int value : firstPositions) {
                if (value >= min) continue;
                min = value;
            }
            return min;
        }

        private int findMax(int[] lastPositions) {
            int max = lastPositions[0];
            for (int value : lastPositions) {
                if (value <= max) continue;
                max = value;
            }
            return max;
        }

        public boolean isOrientation(int orientation) {
            if (orientation == 0) {
                return this.isCanPullDown();
            }
            if (orientation == 1) {
                return this.isCanPullUp();
            }
            return false;
        }

        private boolean isCanPullDown() {
            return !this.canScrollVertically(-1);
        }

        private boolean isCanPullUp() {
            return !this.canScrollVertically(1);
        }

        private boolean isVertical() {
            if (this.staggeredGridLayoutManager != null) {
                return this.staggeredGridLayoutManager.getOrientation() == 1;
            }
            if (this.linearLayoutManager != null) {
                return this.linearLayoutManager.getOrientation() == 1;
            }
            if (this.gridLayoutManager != null) {
                return this.gridLayoutManager.getOrientation() == 1;
            }
            return false;
        }

        private boolean isFullScreen() {
            int height = this.getMeasuredHeight();
            if (this.linearLayoutManager != null) {
                int lastP = this.linearLayoutManager.findLastVisibleItemPosition();
                if (lastP == -1) {
                    return false;
                }
                View last = this.linearLayoutManager.findViewByPosition(lastP);
                return last.getBottom() >= height;
            }
            return false;
        }
    }

    public static interface LoadMoreListener {
        public void onLoadMore();
    }

    public static interface RefreshListener {
        public void onRefresh();
    }
}

