/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.im.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.kangxin.common.R;
import java.lang.ref.WeakReference;

public class ShapedImageView
extends AppCompatImageView {
    private WeakReference<Bitmap> mShape = new WeakReference<Object>(null);
    private Xfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private Paint paint = new Paint(1);
    private int shapeResID;

    public ShapedImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.online_ShapedImageView);
        this.shapeResID = array.getResourceId(R.styleable.online_ShapedImageView_online_shape, 0);
        array.recycle();
    }

    public void setShapeResID(int shapeResID) {
        this.shapeResID = shapeResID;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        int sc = canvas.saveLayer(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight(), null, 31);
        super.onDraw(canvas);
        if (this.shapeResID != 0) {
            Bitmap bitmap = (Bitmap)this.mShape.get();
            if (bitmap == null) {
                bitmap = this.getShape();
                this.mShape = new WeakReference<Bitmap>(bitmap);
            }
            this.paint.setXfermode(this.mode);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.paint);
            this.paint.setXfermode(null);
        }
        canvas.restoreToCount(sc);
    }

    private Bitmap getShape() {
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.shapeResID);
        int newWidth = this.getMeasuredWidth();
        int newHeight = this.getMeasuredHeight();
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float scaleWidth = (float)newWidth / (float)width;
        float scaleHeight = (float)newHeight / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }
}

