/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class RedPointDrawable
extends Drawable {
    private Drawable mDrawable;
    private boolean mShowRedPoint;
    private Paint mPaint;
    private int mRadius;
    private int mGravity = 5;

    public RedPointDrawable(Context context, Drawable origin) {
        this.mDrawable = origin;
        this.mPaint = new Paint(5);
        this.mPaint.setColor(-65536);
        this.mRadius = (int)(context.getResources().getDisplayMetrics().density * 5.0f);
    }

    public static RedPointDrawable wrap(Context context, Drawable drawable2) {
        if (drawable2 instanceof RedPointDrawable) {
            return (RedPointDrawable)drawable2;
        }
        return new RedPointDrawable(context, drawable2);
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setShowRedPoint(boolean showRedPoint) {
        this.mShowRedPoint = showRedPoint;
        this.invalidateSelf();
    }

    public void setRadius(int radius) {
        this.mRadius = radius;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        this.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mDrawable.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return this.mDrawable.getOpacity();
    }

    public int getIntrinsicHeight() {
        return this.mDrawable.getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return this.mDrawable.getIntrinsicWidth();
    }

    public void setBounds(@NonNull Rect bounds) {
        super.setBounds(bounds);
        this.mDrawable.setBounds(bounds);
    }

    public void draw(@NonNull Canvas canvas) {
        this.mDrawable.draw(canvas);
        if (this.mShowRedPoint) {
            int cx = this.getBounds().right;
            int cy = this.getBounds().top;
            if ((3 & this.mGravity) == 3) {
                cx -= this.mRadius;
            } else if ((5 & this.mGravity) == 5) {
                cx += this.mRadius;
            }
            if ((0x30 & this.mGravity) == 48) {
                cy -= this.mRadius;
            } else if ((0x50 & this.mGravity) == 80) {
                cy += this.mRadius;
            }
            canvas.drawCircle((float)cx, (float)cy, (float)this.mRadius, this.mPaint);
        }
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.mDrawable.setBounds(left, top, right, bottom);
    }
}

