/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.onlineoutser.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import org.jetbrains.annotations.NotNull;

public class RemoImFooter
extends LinearLayout {
    private EventListener onMsgSendListener;
    private EditText mInputMsgEdtView;
    private ImageView mSendMsgBtnView;

    public RemoImFooter(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RemoImFooter(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setOrientation(1);
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.remo_teach_im_footer, (ViewGroup)this, false);
        this.addView(rootView);
        this.mInputMsgEdtView = (EditText)this.findViewById(R.id.mInputMsgEdtView);
        this.mSendMsgBtnView = (ImageView)this.findViewById(R.id.mSendMsgButton);
        this.initInputMsgView();
        this.initSendMsgBtn();
    }

    private void initSendMsgBtn() {
        this.mSendMsgBtnView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String inputMsg = RemoImFooter.this.mInputMsgEdtView.getText().toString();
                if (TextUtils.isEmpty((CharSequence)inputMsg)) {
                    ToastUtils.showShort((CharSequence)StringsUtils.getString(R.string.onlineoutser_xiaoxibunengweikong));
                    return;
                }
                RemoImFooter.this.mInputMsgEdtView.setText((CharSequence)"");
                if (RemoImFooter.this.onMsgSendListener != null) {
                    RemoImFooter.this.onMsgSendListener.onText(inputMsg);
                }
            }
        });
    }

    public void setOnMsgSendListener(EventListener eventListener) {
        this.onMsgSendListener = eventListener;
    }

    public void setEdtFocusable(boolean flag) {
        this.mInputMsgEdtView.setFocusable(flag);
    }

    private void initInputMsgView() {
        this.mInputMsgEdtView.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().length() > 0) {
                    RemoImFooter.this.mSendMsgBtnView.setVisibility(0);
                } else {
                    RemoImFooter.this.mSendMsgBtnView.setVisibility(8);
                }
            }
        });
    }

    public static interface EventListener {
        public void onText(@NotNull String var1);
    }
}

