/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.kangxin.common.base.ResponseBody;
import java.io.IOException;
import java.util.TreeMap;
import retrofit2.Converter;

public class BYGsonResponseBodyConverter<T>
implements Converter<okhttp3.ResponseBody, T> {
    private static final String TAG = "BYGsonResponseBodyConve";
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    BYGsonResponseBodyConverter(Gson gson2, TypeAdapter<T> adapter) {
        this.gson = gson2;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T convert(okhttp3.ResponseBody value) throws IOException {
        JsonReader jsonReader = this.gson.newJsonReader(value.charStream());
        try {
            Object result = this.adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            Object object = result;
            return (T)object;
        }
        catch (Exception exception) {
            byte[] bytes = value.bytes();
            String s = new String(bytes);
            Log.i((String)TAG, (String)("convert: exception:" + exception));
            Log.i((String)TAG, (String)("convert: exception:json:" + s));
            TreeMap map = new TreeMap();
            ResponseBody objectResponseBody = new ResponseBody();
            if (map.get("msg") != null) {
                objectResponseBody.setMsg(map.get("msg").toString());
            }
            if (map.get("code") != null) {
                objectResponseBody.setCode(map.get("code").toString());
            }
            if (map.get("errCode") != null) {
                objectResponseBody.setErrCode(map.get("errCode").toString());
            }
            objectResponseBody.setCode("0");
            objectResponseBody.setErrCode("");
            Object result = this.adapter.fromJson(this.gson.toJson(objectResponseBody));
            exception.printStackTrace();
            Object object = result;
            return (T)object;
        }
        finally {
            value.close();
        }
    }
}

