/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.progress;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.kangxin.common.R;
import com.kangxin.common.byh.progress.LoadingView;

public class SVProgressDefaultView
extends LinearLayout {
    private int resInfo = R.drawable.ic_svstatus_info;
    private int resSuccess = R.drawable.ic_svstatus_success;
    private int resError = R.drawable.ic_svstatus_error;
    private TextView tvMsg;
    private LoadingView mLoadingView;
    private ImageView mIv;
    private RotateAnimation mRotateAnimation;

    public SVProgressDefaultView(Context context) {
        super(context);
        this.initViews();
        this.init();
    }

    private void initViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_svprogressdefault, (ViewGroup)this, true);
        this.setGravity(17);
        this.mLoadingView = (LoadingView)this.findViewById(R.id.loadingView);
        this.mIv = (ImageView)this.findViewById(R.id.ivSmallLoading);
        this.tvMsg = (TextView)this.findViewById(R.id.tvMsg);
    }

    private void init() {
        this.mRotateAnimation = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setDuration(1000L);
        this.mRotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mRotateAnimation.setRepeatCount(-1);
        this.mRotateAnimation.setRepeatMode(1);
    }

    public void showWithStatus(String string2) {
        this.showBaseStatus(0, string2);
    }

    public void showInfoWithStatus(String string2) {
        this.showBaseStatus(this.resInfo, string2);
    }

    public void showSuccessWithStatus(String string2) {
        this.showBaseStatus(this.resSuccess, string2);
    }

    public void showErrorWithStatus(final String string2) {
        this.post(new Runnable(){

            @Override
            public void run() {
                SVProgressDefaultView.this.showBaseStatus(SVProgressDefaultView.this.resError, string2);
            }
        });
    }

    public void setText(String string2) {
        this.tvMsg.setText((CharSequence)string2);
    }

    public void showBaseStatus(int res, String string2) {
        if (res == 0) {
            this.mLoadingView.setVisibility(0);
            this.mIv.setVisibility(8);
        } else {
            this.mLoadingView.setVisibility(8);
            this.mIv.setVisibility(0);
            this.mIv.setImageResource(res);
        }
        this.tvMsg.setText((CharSequence)string2);
        this.tvMsg.setVisibility(0);
    }
}

