/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.progress;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.kangxin.common.R;
import com.kangxin.common.byh.progress.SVProgressDefaultView;
import com.kangxin.common.byh.progress.SVProgressHUDAnimateUtil;

public class SVProgressHUD {
    private static final long DISMISSDELAYED = 1500L;
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private Context context;
    private SVProgressHUDMaskType mSVProgressHUDMaskType;
    private ViewGroup decorView;
    private ViewGroup rootView;
    private SVProgressDefaultView mSharedView;
    Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            SVProgressHUD.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };
    private Animation outAnim;
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                SVProgressHUD.this.dismiss();
                SVProgressHUD.this.setCancelable(false);
            }
            return false;
        }
    };
    private Animation inAnim;
    private int gravity;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            SVProgressHUD.this.dismiss();
        }
    };

    public SVProgressHUD(Context context) {
        this.context = context;
        this.gravity = 17;
        this.initViews();
        this.initDefaultView();
        this.initAnimation();
    }

    protected void initViews() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
        this.rootView = (ViewGroup)layoutInflater.inflate(R.layout.layout_svprogresshud, (ViewGroup)null, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected void initDefaultView() {
        this.mSharedView = new SVProgressDefaultView(this.context);
        this.params.gravity = this.gravity;
        this.mSharedView.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    protected void initAnimation() {
        if (this.inAnim == null) {
            this.inAnim = this.getInAnimation();
        }
        if (this.outAnim == null) {
            this.outAnim = this.getOutAnimation();
        }
    }

    private void onAttached() {
        this.decorView.addView((View)this.rootView);
        if (this.mSharedView.getParent() != null) {
            ((ViewGroup)this.mSharedView.getParent()).removeView((View)this.mSharedView);
        }
        this.rootView.addView((View)this.mSharedView);
    }

    private void svShow() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (!this.isShowing()) {
            this.onAttached();
        }
        this.mSharedView.startAnimation(this.inAnim);
    }

    public void showWithStatus(String string2) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showWithStatus(string2);
        this.svShow();
    }

    public void showWithStatus(String string2, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showWithStatus(string2);
        this.svShow();
    }

    public void showInfoWithStatus(String string2) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showInfoWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void showInfoWithStatus(String string2, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showInfoWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void showSuccessWithStatus(String string2) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showSuccessWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void showSuccessWithStatus(String string2, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showSuccessWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void showErrorWithStatus(String string2) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showErrorWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void showErrorWithStatus(String string2, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showErrorWithStatus(string2);
        this.svShow();
        this.scheduleDismiss();
    }

    public void setText(String string2) {
        this.mSharedView.setText(string2);
    }

    private void setMaskType(SVProgressHUDMaskType maskType) {
        this.mSVProgressHUDMaskType = maskType;
        switch (this.mSVProgressHUDMaskType) {
            case None: {
                this.configMaskType(R.color.transparent, false, false);
                break;
            }
            case Clear: {
                this.configMaskType(R.color.transparent, true, false);
                break;
            }
            case ClearCancel: {
                this.configMaskType(R.color.transparent, true, true);
                break;
            }
            case Black: {
                this.configMaskType(R.color.bgColor_overlay, true, false);
                break;
            }
            case BlackCancel: {
                this.configMaskType(R.color.bgColor_overlay, true, true);
                break;
            }
            case Gradient: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, false);
                break;
            }
            case GradientCancel: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, true);
            }
        }
    }

    private void configMaskType(int bg, boolean clickable, boolean cancelable) {
        this.rootView.setBackgroundResource(bg);
        this.rootView.setClickable(clickable);
        this.setCancelable(cancelable);
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null;
    }

    public void dismiss() {
        this.outAnim.setAnimationListener(this.outAnimListener);
        this.mSharedView.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        this.rootView.removeView((View)this.mSharedView);
        this.decorView.removeView((View)this.rootView);
        this.context = null;
    }

    public Animation getInAnimation() {
        int res = SVProgressHUDAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    public Animation getOutAnimation() {
        int res = SVProgressHUDAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)res);
    }

    private void setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.sv_outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener((View.OnTouchListener)null);
        }
    }

    private void scheduleDismiss() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.sendEmptyMessageDelayed(0, 1500L);
    }

    public static enum SVProgressHUDMaskType {
        None,
        Clear,
        Black,
        Gradient,
        ClearCancel,
        BlackCancel,
        GradientCancel;

    }
}

