/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.core.app.NotificationCompat;
import com.blankj.utilcode.util.LogUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BadgeUtil {
    private BadgeUtil() throws InstantiationException {
        throw new InstantiationException("This class is not for instantiation");
    }

    public static void setBadgeCount(Context context, int count, int iconResId) {
        count = count <= 0 ? 0 : Math.max(0, Math.min(count, 99));
        LogUtils.d((Object[])new Object[]{"\u6253\u5370\u6570\u636e---" + Build.MANUFACTURER});
        String str1 = Build.MANUFACTURER;
        if (!Build.MANUFACTURER.equalsIgnoreCase("xiaomi")) {
            if (Build.MANUFACTURER.equalsIgnoreCase("sony")) {
                BadgeUtil.setBadgeOfSony(context, count);
            } else if (Build.MANUFACTURER.toLowerCase().contains("samsung") || Build.MANUFACTURER.toLowerCase().contains("lg")) {
                BadgeUtil.setBadgeOfSumsung(context, count);
            } else if (Build.MANUFACTURER.toLowerCase().contains("htc")) {
                BadgeUtil.setBadgeOfHTC(context, count);
            } else if (Build.MANUFACTURER.toLowerCase().contains("nova")) {
                BadgeUtil.setBadgeOfNova(context, count);
            } else if (!(Build.MANUFACTURER.equalsIgnoreCase("OPPO") || Build.MANUFACTURER.toLowerCase().contains("LeMobile") || Build.MANUFACTURER.equalsIgnoreCase("vivo"))) {
                if (Build.MANUFACTURER.equalsIgnoreCase("HUAWEI") || Build.BRAND.equals("HONOR")) {
                    BadgeUtil.setHuaweiBadge(context, count);
                } else if (Build.MANUFACTURER.toLowerCase().contains("Meizu") || Build.MANUFACTURER.toLowerCase().contains("") || Build.MANUFACTURER.toLowerCase().contains("")) {
                    // empty if block
                }
            }
        }
    }

    private static void setBadgeOfMIUI(Context context, int count, int iconResId) {
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setContentTitle((CharSequence)StringsUtils.getString(R.string.app_name)).setContentText((CharSequence)(StringsUtils.getString(R.string.commbyh_ninyou) + count + StringsUtils.getString(R.string.commbyh_tiaoweidudetongzhixiaoxi))).setSmallIcon(iconResId);
        Notification notification = builder.build();
        try {
            Field field = notification.getClass().getDeclaredField("extraNotification");
            Object extraNotification = field.get(notification);
            Method method = extraNotification.getClass().getDeclaredMethod("setMessageCount", Integer.TYPE);
            method.invoke(extraNotification, count);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.e((Object[])new Object[]{"\u6253\u5370\u4e00\u4e0b\u6570\u636e\u8868" + e.getMessage()});
        }
        mNotificationManager.notify("miui", 0, notification);
        if (count == 0) {
            mNotificationManager.cancel("miui", 0);
        }
    }

    private static void setBadgeOfSony(Context context, int count) {
        String launcherClassName = BadgeUtil.getLauncherClassName(context);
        if (launcherClassName == null) {
            return;
        }
        boolean isShow = true;
        if (count == 0) {
            isShow = false;
        }
        Intent localIntent = new Intent();
        localIntent.setAction("com.sonyericsson.home.action.UPDATE_BADGE");
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE", isShow);
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME", launcherClassName);
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.MESSAGE", String.valueOf(count));
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(localIntent);
    }

    private static void setBadgeOfSumsung(Context context, int count) {
        String launcherClassName = BadgeUtil.getLauncherClassName(context);
        if (launcherClassName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", context.getPackageName());
        intent.putExtra("badge_count_class_name", launcherClassName);
        context.sendBroadcast(intent);
    }

    private static void setBadgeOfHTC(Context context, int count) {
        Intent intentNotification = new Intent("com.htc.launcher.action.SET_NOTIFICATION");
        ComponentName localComponentName = new ComponentName(context.getPackageName(), BadgeUtil.getLauncherClassName(context));
        intentNotification.putExtra("com.htc.launcher.extra.COMPONENT", localComponentName.flattenToShortString());
        intentNotification.putExtra("com.htc.launcher.extra.COUNT", count);
        context.sendBroadcast(intentNotification);
        Intent intentShortcut = new Intent("com.htc.launcher.action.UPDATE_SHORTCUT");
        intentShortcut.putExtra("packagename", context.getPackageName());
        intentShortcut.putExtra("count", count);
        context.sendBroadcast(intentShortcut);
    }

    private static void setBadgeOfNova(Context context, int count) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("tag", context.getPackageName() + "/" + BadgeUtil.getLauncherClassName(context));
        contentValues.put("count", Integer.valueOf(count));
        context.getContentResolver().insert(Uri.parse((String)"content://com.teslacoilsw.notifier/unread_count"), contentValues);
    }

    private static void setBadgeOfVIVO(Context context, int count) {
        try {
            Intent intent = new Intent("launcher.action.CHANGE_APPLICATION_NOTIFICATION_NUM");
            intent.putExtra("packageName", context.getPackageName());
            String launchClassName = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent().getClassName();
            intent.putExtra("className", launchClassName);
            intent.putExtra("notificationNum", count);
            context.sendBroadcast(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setBadgeOfOPPO(Context context, int count) {
        Bundle extras = new Bundle();
        extras.putInt("app_badge_count", count);
        context.getContentResolver().call(Uri.parse((String)"content://com.android.badge/badge"), "setAppBadgeCount", String.valueOf(count), extras);
    }

    public static void setHuaweiBadge(Context context, int count) {
        try {
            Bundle bundle = new Bundle();
            bundle.putString("package", context.getPackageName());
            String launchClassName = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName()).getComponent().getClassName();
            bundle.putString("class", launchClassName);
            bundle.putInt("badgenumber", count);
            Bundle bundle2 = context.getContentResolver().call(Uri.parse((String)"content://com.huawei.android.launcher.settings/badge/"), "change_badge", null, bundle);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtils.e((Object[])new Object[]{"\u6253\u5370\u4e00\u4e0b\u6570\u636e\u8868" + e.getMessage()});
        }
    }

    public static void setZukBadge(Context context, int counts) {
        Uri CONTENT_URI = Uri.parse((String)("content://" + context.getPackageName() + "/badge"));
        Bundle extra = new Bundle();
        extra.putInt("app_badge_count", counts);
        Bundle b = null;
        b = context.getContentResolver().call(CONTENT_URI, "setAppBadgeCount", null, extra);
        boolean result = false;
        result = b != null;
        Intent shortcut = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
        shortcut.putExtra("android.intent.extra.shortcut.NAME", context.getResources().getString(R.string.app_name));
        shortcut.putExtra("duplicate", false);
        Intent shortcutIntent = new Intent();
        shortcutIntent.setClassName("com.example", "com.example.MainActivity");
        shortcutIntent.setPackage(context.getPackageName());
        shortcut.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        Intent.ShortcutIconResource iconRes = Intent.ShortcutIconResource.fromContext((Context)context, (int)R.mipmap.ic_launcher);
        shortcut.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconRes);
        shortcut.putExtra("app_shortcut_custom_id", "example_custom_id");
        context.sendBroadcast(shortcut);
    }

    public static void setBadgeOfMadMode(Context context, int count, String packageName, String className) {
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", packageName);
        intent.putExtra("badge_count_class_name", className);
        context.sendBroadcast(intent);
    }

    public static void resetBadgeCount(Context context, int iconResId) {
        BadgeUtil.setBadgeCount(context, 0, iconResId);
    }

    public static String getLauncherClassName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setPackage(context.getPackageName());
        intent.addCategory("android.intent.category.LAUNCHER");
        ResolveInfo info = packageManager.resolveActivity(intent, 65536);
        if (info == null) {
            info = packageManager.resolveActivity(intent, 0);
        }
        return info.activityInfo.name;
    }

    public static void showBadgeRed() {
    }

    public static void showBadgeRed(Context mContext, Integer count) {
        BadgeUtil.setBadgeCount(mContext, count, R.drawable.shape_red_point);
    }
}

