/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.lang.ref.WeakReference;

public class CountDownUtil {
    private final int MSG_WHAT_START = 10010;
    private WeakReference<TextView> mWeakReference;
    private long mCountDownMillis = 60000L;
    private String mHintText = StringsUtils.getString(R.string.commbyh_houzaicifasong);
    private long mLastMillis;
    private long mIntervalMillis = 1000L;
    private int usableColorId = 17170450;
    private int unusableColorId = 0x1060000;
    private OnDownEndListener onDownEndListener;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 10010: {
                    if (CountDownUtil.this.mLastMillis > 0L) {
                        CountDownUtil.this.setUsable(false);
                        CountDownUtil.this.mLastMillis = CountDownUtil.this.mLastMillis - CountDownUtil.this.mIntervalMillis;
                        if (CountDownUtil.this.mWeakReference.get() == null) break;
                        CountDownUtil.this.mHandler.sendEmptyMessageDelayed(10010, CountDownUtil.this.mIntervalMillis);
                        break;
                    }
                    CountDownUtil.this.setUsable(true);
                    if (CountDownUtil.this.onDownEndListener == null) break;
                    CountDownUtil.this.onDownEndListener.onEnd();
                }
            }
        }
    };

    public CountDownUtil(TextView textView) {
        this.mWeakReference = new WeakReference<TextView>(textView);
    }

    public CountDownUtil(TextView textView, long countDownMillis) {
        this.mWeakReference = new WeakReference<TextView>(textView);
        this.mCountDownMillis = countDownMillis;
    }

    public void setOnDownEndListener(OnDownEndListener onDownEndListener) {
        this.onDownEndListener = onDownEndListener;
    }

    public CountDownUtil setCountDownMillis(long countDownMillis) {
        this.mCountDownMillis = countDownMillis;
        return this;
    }

    public void setUsable(boolean usable) {
        TextView mTextView = (TextView)this.mWeakReference.get();
        if (mTextView != null) {
            if (usable) {
                if (!mTextView.isClickable()) {
                    mTextView.setClickable(usable);
                    mTextView.setTextColor(mTextView.getResources().getColor(this.usableColorId));
                    mTextView.setText((CharSequence)this.mHintText);
                }
            } else {
                if (mTextView.isClickable()) {
                    mTextView.setClickable(usable);
                    mTextView.setTextColor(mTextView.getResources().getColor(this.unusableColorId));
                }
                String content = this.mLastMillis / 1000L + "s" + this.mHintText.trim();
                mTextView.setText((CharSequence)content);
            }
        }
    }

    public CountDownUtil setCountDownColor(@ColorRes int usableColorId, @ColorRes int unusableColorId) {
        this.usableColorId = usableColorId;
        this.unusableColorId = unusableColorId;
        return this;
    }

    public CountDownUtil start() {
        this.mLastMillis = this.mCountDownMillis;
        this.mHandler.sendEmptyMessage(10010);
        return this;
    }

    public CountDownUtil setOnClickListener(final @Nullable View.OnClickListener onClickListener) {
        TextView mTextView = (TextView)this.mWeakReference.get();
        if (mTextView != null) {
            mTextView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CountDownUtil.this.mHandler.removeMessages(10010);
                    CountDownUtil.this.start();
                    onClickListener.onClick(v);
                }
            });
        }
        return this;
    }

    public CountDownUtil reset() {
        this.mLastMillis = 0L;
        this.mHandler.sendEmptyMessage(10010);
        return this;
    }

    public static interface OnDownEndListener {
        public void onEnd();
    }
}

