/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.graphics.Typeface;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.android.material.tabs.TabLayout;
import com.kangxin.common.R;

public class TabLayoutHelper {
    private Builder builder;

    private TabLayoutHelper(Builder builder, float sizeFont) {
        this.builder = builder;
        this.init(sizeFont);
    }

    private void init(float sizeFont) {
        if (this.builder.getTabLayout() == null) {
            return;
        }
        TabLayout tabLayout = this.builder.getTabLayout();
        tabLayout.setSelectedTabIndicatorHeight(0);
        this.initView(tabLayout, sizeFont);
        this.initListener(tabLayout, sizeFont);
    }

    private void initListener(TabLayout tabLayout, final float sizeFont) {
        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                if (tab.getCustomView() == null) {
                    return;
                }
                TextView textView = (TextView)tab.getCustomView().findViewById(R.id.tv_tab);
                textView.setTextSize(sizeFont);
                if (TabLayoutHelper.this.builder.getSelectedTextColor() != 0) {
                    textView.setTextColor(TabLayoutHelper.this.builder.getSelectedTextColor());
                }
                if (TabLayoutHelper.this.builder.isSelectedBold()) {
                    textView.setTypeface(Typeface.defaultFromStyle((int)1));
                }
                if (TabLayoutHelper.this.builder.getSelectedBackgroundColor() != 0) {
                    textView.setBackgroundColor(TabLayoutHelper.this.builder.getSelectedBackgroundColor());
                }
                tab.getCustomView().findViewById(R.id.view_indicator).setVisibility(0);
            }

            public void onTabUnselected(TabLayout.Tab tab) {
                if (tab.getCustomView() == null) {
                    return;
                }
                TextView textView = (TextView)tab.getCustomView().findViewById(R.id.tv_tab);
                textView.setTextSize(sizeFont);
                if (TabLayoutHelper.this.builder.getNormalTextColor() != 0) {
                    textView.setTextColor(TabLayoutHelper.this.builder.getNormalTextColor());
                }
                textView.setTypeface(Typeface.defaultFromStyle((int)0));
                if (TabLayoutHelper.this.builder.getNormalBackgroundColor() != 0) {
                    textView.setBackgroundColor(TabLayoutHelper.this.builder.getNormalBackgroundColor());
                }
                tab.getCustomView().findViewById(R.id.view_indicator).setVisibility(8);
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
    }

    private void initView(final TabLayout tabLayout, final float sizeFont) {
        this.builder.getTabLayout().post(new Runnable(){

            @Override
            public void run() {
                try {
                    LinearLayout childAt = (LinearLayout)tabLayout.getChildAt(0);
                    for (int j = 0; j < childAt.getChildCount(); ++j) {
                        TabLayout.Tab tab = tabLayout.getTabAt(j);
                        if (tab == null) {
                            return;
                        }
                        CharSequence text = tab.getText();
                        tab.setCustomView(R.layout.by_item_tab_view);
                        if (tab.getCustomView() == null) {
                            return;
                        }
                        View customView = tab.getCustomView();
                        TextView textView = (TextView)customView.findViewById(R.id.tv_tab);
                        textView.setTextSize(sizeFont);
                        textView.setText(text);
                        int tabTextColor = TabLayoutHelper.this.builder.getTabTextColor();
                        if (tabTextColor != 0) {
                            textView.setTextColor(tabTextColor);
                        }
                        if (TabLayoutHelper.this.builder.getNormalBackgroundColor() != 0) {
                            textView.setBackgroundColor(TabLayoutHelper.this.builder.getNormalBackgroundColor());
                        }
                        View indicator = customView.findViewById(R.id.view_indicator);
                        if (j == 0) {
                            int color2 = TabLayoutHelper.this.builder.getSelectedTextColor();
                            if (color2 == 0) {
                                color2 = R.color.gray_666666;
                            }
                            textView.setTextColor(color2);
                            if (TabLayoutHelper.this.builder.isSelectedBold()) {
                                textView.setTypeface(Typeface.defaultFromStyle((int)1));
                            }
                            if (TabLayoutHelper.this.builder.getSelectedBackgroundColor() != 0) {
                                textView.setBackgroundColor(TabLayoutHelper.this.builder.getSelectedBackgroundColor());
                            }
                            indicator.setVisibility(0);
                        }
                        FrameLayout.LayoutParams indicatorLayout = (FrameLayout.LayoutParams)indicator.getLayoutParams();
                        if (TabLayoutHelper.this.builder.getIndicatorWith() != 0) {
                            indicatorLayout.width = TabLayoutHelper.this.builder.getIndicatorWith();
                        }
                        if (TabLayoutHelper.this.builder.getIndicatorHeight() != 0) {
                            indicatorLayout.height = TabLayoutHelper.this.builder.getIndicatorHeight();
                        }
                        if (TabLayoutHelper.this.builder.getIndicatorColor() != 0) {
                            indicator.setBackgroundColor(TabLayoutHelper.this.builder.getIndicatorColor());
                        }
                        if (TabLayoutHelper.this.builder.getIndicatorMargin() != 0) {
                            indicatorLayout.rightMargin = TabLayoutHelper.this.builder.getIndicatorMargin();
                            indicatorLayout.leftMargin = TabLayoutHelper.this.builder.getIndicatorMargin();
                        }
                        if (TabLayoutHelper.this.builder.getIndicatorDrawable() != 0) {
                            indicator.setBackgroundResource(TabLayoutHelper.this.builder.getIndicatorDrawable());
                        }
                        childAt.getChildAt(j).setPadding(TabLayoutHelper.this.builder.getTabItemPadding(), 0, TabLayoutHelper.this.builder.getTabItemPadding(), 0);
                        LinearLayout.LayoutParams lLayoutParams = (LinearLayout.LayoutParams)childAt.getChildAt(j).getLayoutParams();
                        lLayoutParams.rightMargin = TabLayoutHelper.this.builder.getTabItemMarginRight();
                        lLayoutParams.leftMargin = TabLayoutHelper.this.builder.getTabItemMarginLeft();
                        if (TabLayoutHelper.this.builder.getTabItemWith() == 0) continue;
                        lLayoutParams.width = TabLayoutHelper.this.builder.getTabItemWith();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static class Builder {
        private int selectedTextColor;
        private int tabTextColor;
        private int normalTextColor;
        private int normalBackgroundColor;
        private int SelectedBackgroundColor;
        private boolean selectedBold;
        private int indicatorWith;
        private int indicatorHeight;
        private int indicatorColor;
        private int indicatorDrawable;
        private int indicatorMargin;
        private int tabItemWith;
        private int tabItemPadding;
        private int tabItemMarginRight;
        private int tabItemMarginLeft;
        private TabLayout tabLayout;

        public Builder(TabLayout tabLayout) {
            this.tabLayout = tabLayout;
        }

        public int getTabItemPadding() {
            return this.tabItemPadding;
        }

        public Builder setTabItemPadding(int tabItemPadding) {
            this.tabItemPadding = tabItemPadding;
            return this;
        }

        private TabLayout getTabLayout() {
            return this.tabLayout;
        }

        private int getSelectedTextColor() {
            return this.selectedTextColor;
        }

        public Builder setSelectedTextColor(int selectedTextColor) {
            this.selectedTextColor = selectedTextColor;
            return this;
        }

        public int getTabTextColor() {
            return this.tabTextColor;
        }

        public Builder setTabTextColor(int textColor) {
            this.tabTextColor = textColor;
            return this;
        }

        private int getIndicatorMargin() {
            return this.indicatorMargin;
        }

        public Builder setIndicatorMargin(int indicatorMargin) {
            this.indicatorMargin = indicatorMargin;
            return this;
        }

        private int getIndicatorDrawable() {
            return this.indicatorDrawable;
        }

        public Builder setIndicatorDrawable(int indicatorDrawable) {
            this.indicatorDrawable = indicatorDrawable;
            return this;
        }

        private int getNormalBackgroundColor() {
            return this.normalBackgroundColor;
        }

        public Builder setNormalBackgroundColor(int normalBackgroundColor) {
            this.normalBackgroundColor = normalBackgroundColor;
            return this;
        }

        private int getNormalTextColor() {
            return this.normalTextColor;
        }

        public Builder setNormalTextColor(int normalTextColor) {
            this.normalTextColor = normalTextColor;
            return this;
        }

        private int getSelectedBackgroundColor() {
            return this.SelectedBackgroundColor;
        }

        public Builder setSelectedBackgroundColor(int selectedBackgroundColor) {
            this.SelectedBackgroundColor = selectedBackgroundColor;
            return this;
        }

        private boolean isSelectedBold() {
            return this.selectedBold;
        }

        public Builder setSelectedBold(boolean selectedBold) {
            this.selectedBold = selectedBold;
            return this;
        }

        private int getIndicatorWith() {
            return this.indicatorWith;
        }

        public Builder setIndicatorWith(int indicatorWith) {
            this.indicatorWith = indicatorWith;
            return this;
        }

        private int getIndicatorHeight() {
            return this.indicatorHeight;
        }

        public Builder setIndicatorHeight(int indicatorHeight) {
            this.indicatorHeight = indicatorHeight;
            return this;
        }

        private int getIndicatorColor() {
            return this.indicatorColor;
        }

        public Builder setIndicatorColor(int indicatorColor) {
            this.indicatorColor = indicatorColor;
            return this;
        }

        private int getTabItemWith() {
            return this.tabItemWith;
        }

        public Builder setTabItemWith(int tabItemWith) {
            this.tabItemWith = tabItemWith;
            return this;
        }

        private int getTabItemMarginRight() {
            return this.tabItemMarginRight;
        }

        public Builder setTabItemMarginRight(int tabItemMarginRight) {
            this.tabItemMarginRight = tabItemMarginRight;
            return this;
        }

        private int getTabItemMarginLeft() {
            return this.tabItemMarginLeft;
        }

        public Builder setTabItemMarginLeft(int tabItemMarginLeft) {
            this.tabItemMarginLeft = tabItemMarginLeft;
            return this;
        }

        public TabLayoutHelper build(float sizeFont) {
            return new TabLayoutHelper(this, sizeFont);
        }
    }

    public static interface OnTabSelectListener {
        public void onSelected(TabLayout.Tab var1);

        public void onUnSelect(TabLayout.Tab var1);
    }
}

