/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.util;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.blankj.utilcode.util.TimeUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeUtil {
    public static final String FORMAT_TIME = "HH:mm";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_MONTH_DAY_TIME = "MM-dd HH:mm";
    public static final String FORMAT_DATE = "yyyy-MM-dd";

    public static String getFormatToday(String dateFormat) {
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(currentTime);
    }

    public static Date stringToDate(String dateStr, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String dateToString(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        return formatter.format(date);
    }

    public static String getChatTime(boolean hasYear, long timesamp) {
        String result;
        long clearTime = timesamp;
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today)) - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0: {
                result = StringsUtils.getString(R.string.commbyh_jintian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 1: {
                result = StringsUtils.getString(R.string.commbyh_zuotian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            case 2: {
                result = StringsUtils.getString(R.string.commbyh_qiantian_) + TimeUtil.getHourAndMin(clearTime);
                break;
            }
            default: {
                result = TimeUtil.getTime(hasYear, clearTime);
            }
        }
        return result;
    }

    public static String getTime(boolean hasYear, long time) {
        String pattern = FORMAT_DATE_TIME;
        if (!hasYear) {
            pattern = FORMAT_MONTH_DAY_TIME;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date(time));
    }

    private static String getHourAndMin(long time) {
        SimpleDateFormat format = new SimpleDateFormat(FORMAT_TIME);
        return format.format(new Date(time));
    }

    public static String getWeekOfDate(Date date) {
        String[] weekDays = new String[]{StringsUtils.getString(R.string.commbyh_xingqiri), StringsUtils.getString(R.string.commbyh_xingqiyi), StringsUtils.getString(R.string.commbyh_xingqier), StringsUtils.getString(R.string.commbyh_xingqisan), StringsUtils.getString(R.string.commbyh_xingqisi), StringsUtils.getString(R.string.commbyh_xingqiwu), StringsUtils.getString(R.string.commbyh_xingqiliu)};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static String converTime(String srcTime, TimeZone timezone) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        SimpleDateFormat dspFmt = new SimpleDateFormat(FORMAT_DATE_TIME);
        long result_time = 0L;
        if (null == srcTime) {
            result_time = System.currentTimeMillis();
        } else {
            try {
                sdf.setTimeZone(TimeZone.getTimeZone("GMT00:00"));
                Date result_date = sdf.parse(srcTime);
                result_time = result_date.getTime();
            }
            catch (Exception e) {
                result_time = System.currentTimeMillis();
                dspFmt.setTimeZone(TimeZone.getDefault());
                String convertTime = dspFmt.format(result_time);
                return convertTime;
            }
        }
        dspFmt.setTimeZone(timezone);
        String convertTime = dspFmt.format(result_time);
        return convertTime;
    }

    public static String date2Timestamp(String date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return String.valueOf(sdf.parse(date).getTime());
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static String timeStamp2Date(long time, String format) {
        if (format == null || format.isEmpty()) {
            format = FORMAT_DATE_TIME_SECOND;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(time));
    }

    public static String dateToStamp(String date) {
        SimpleDateFormat sf1 = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat sf2 = new SimpleDateFormat(StringsUtils.getString(R.string.commbyh_yyyynianmmyue));
        String sfStr = "";
        try {
            sfStr = sf2.format(sf1.parse(date));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sfStr;
    }

    public static String timeToMinutes(long second) {
        long minutes = second / 60L;
        long counterpart = second;
        long aminute = 60L;
        return (minutes >= 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (counterpart >= 10L ? Long.valueOf(counterpart) : "0" + (counterpart %= aminute));
    }

    public static String secondToTime(long second) {
        long counterpart = second;
        long aminute = 60L;
        long ahour = aminute * 60L;
        long aday = ahour * 24L;
        long amonth = aday * 30L;
        long ayear = aday * 365L;
        long years = second / ayear;
        long months = (second %= ayear) / amonth;
        long days = (second %= amonth) / aday;
        long hours = (second %= aday) / ahour;
        long minutes = (second %= ahour) / aminute;
        second %= aminute;
        if (years > 0L) {
            if (months > 0L) {
                return years + StringsUtils.getString(R.string.commbyh_nian) + months + StringsUtils.getString(R.string.commbyh_yue) + days + StringsUtils.getString(R.string.commbyh_tian);
            }
            return years + StringsUtils.getString(R.string.commbyh_nian) + days + StringsUtils.getString(R.string.commbyh_tian);
        }
        if (months > 0L) {
            return months + StringsUtils.getString(R.string.commbyh_yue) + days + StringsUtils.getString(R.string.commbyh_tian);
        }
        if (counterpart > 3L * aday) {
            return days + StringsUtils.getString(R.string.commbyh_tian) + hours + StringsUtils.getString(R.string.commbyh_xiaoshi);
        }
        hours = counterpart / ahour;
        minutes = (counterpart %= ahour) / aminute;
        return (hours >= 10L ? Long.valueOf(hours) : "0" + hours) + ":" + (minutes >= 10L ? Long.valueOf(minutes) : "0" + minutes) + ":" + (counterpart >= 10L ? Long.valueOf(counterpart) : "0" + (counterpart %= aminute));
    }

    public static int getAge(String birthDay) throws Exception {
        Date date = TimeUtils.string2Date((String)birthDay, (DateFormat)new SimpleDateFormat(FORMAT_DATE));
        Calendar cal = Calendar.getInstance();
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException("The birthDay is before Now.It's unbelievable!");
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(date);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static long parseTimeDate(String time) {
        if (TextUtils.isEmpty((CharSequence)time)) {
            return -1L;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_DATE_TIME_SECOND);
        try {
            Date date = simpleDateFormat.parse(time);
            if (date != null) {
                return date.getTime();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
        return -1L;
    }
}

