/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsoluteLayout;
import android.widget.ProgressBar;
import com.blankj.utilcode.util.ToastUtils;
import com.kangxin.common.R;
import com.kangxin.common.util.StringsUtils;

public class ProgressWebView
extends WebView {
    private ProgressBar mProgressBar;
    private CountDownTimer timer;

    public ProgressWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mProgressBar = new ProgressBar(context, null, 16842872);
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(-1, 3, 0, 0));
        this.addView((View)this.mProgressBar);
        this.mProgressBar.setProgressDrawable(context.getResources().getDrawable(R.drawable.commbyh_web_progress_bar_states));
        this.getSettings().setDomStorageEnabled(true);
        this.setWebChromeClient(new WebChromeClient());
    }

    private void cancelCountDownTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void starCountDownTimer() {
        if (this.timer == null) {
            this.timer = new CountDownTimer(15000L, 1000L){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    ToastUtils.showLong((CharSequence)StringsUtils.getString(R.string.commbyh_jiazaishibai));
                }
            };
            this.timer.start();
        }
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        AbsoluteLayout.LayoutParams lp = (AbsoluteLayout.LayoutParams)this.mProgressBar.getLayoutParams();
        lp.x = l;
        lp.y = t;
        this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)lp);
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public class WebChromeClient
    extends android.webkit.WebChromeClient {
        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                ProgressWebView.this.mProgressBar.setVisibility(8);
                ProgressWebView.this.cancelCountDownTimer();
            } else {
                if (ProgressWebView.this.mProgressBar.getVisibility() == 8) {
                    ProgressWebView.this.mProgressBar.setVisibility(0);
                }
                ProgressWebView.this.mProgressBar.setProgress(newProgress);
                ProgressWebView.this.starCountDownTimer();
            }
            super.onProgressChanged(view, newProgress);
        }
    }
}

