/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.byh.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.kangxin.common.R;
import java.util.List;

public class TwoLinkageListView
extends RelativeLayout {
    private static RecyclerView mLeftCyclerView;
    private static RecyclerView mRightCyclerView;
    private static Context mContext;
    private BaseLinkageAdapter mLinkageListAdapter;

    public TwoLinkageListView(Context context) {
        this(context, null);
    }

    public TwoLinkageListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TwoLinkageListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.keshi_fragment, (ViewGroup)this);
        mLeftCyclerView = (RecyclerView)this.findViewById(R.id.left_list);
        mLeftCyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        mRightCyclerView = (RecyclerView)this.findViewById(R.id.right_list);
        mRightCyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
    }

    public void setLinkageListAdapter(BaseLinkageAdapter linkageListAdapter) {
        this.mLinkageListAdapter = linkageListAdapter;
        this.mLinkageListAdapter.bindDataToView();
    }

    public static abstract class BaseLinkageAdapter<LEFT, RIGHT> {
        private boolean isDefShow;
        private View mPreItemView;
        private List<LEFT> mLeftDatas;
        private BaseQuickAdapter.OnItemClickListener linkItemClickListener;

        public BaseLinkageAdapter(List<LEFT> mLeftDatas, boolean isDefShow) {
            this.mLeftDatas = mLeftDatas;
            this.isDefShow = isDefShow;
        }

        public void setOnItemClickListener(BaseQuickAdapter.OnItemClickListener onItemClickListener) {
            this.linkItemClickListener = onItemClickListener;
        }

        private void bindDataToView() {
            List<RIGHT> rightList;
            BaseQuickAdapter leftQuickAdapter = new BaseQuickAdapter<LEFT, BaseViewHolder>(this.getLeftLayoutId(), this.mLeftDatas){

                protected void convert(BaseViewHolder helper, LEFT item) {
                    this.leftConvert(helper, item);
                }

                public void onBindViewHolder(BaseViewHolder holder, int position) {
                    super.onBindViewHolder(holder, position);
                    if (isDefShow && position == 0) {
                        holder.itemView.setBackgroundColor(this.mContext.getResources().getColor(17170443));
                        mPreItemView = holder.itemView;
                    }
                }
            };
            leftQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

                public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                    if (mPreItemView != null) {
                        mPreItemView.setBackgroundColor(mContext.getResources().getColor(R.color.gray_f7f8f7));
                    }
                    view.setBackgroundColor(mContext.getResources().getColor(R.color.white));
                    mPreItemView = view;
                    Object item = mLeftDatas.get(position);
                    this.setRightAdapter(this.getSubList(item));
                }
            });
            mLeftCyclerView.setAdapter((RecyclerView.Adapter)leftQuickAdapter);
            if (this.isDefShow && this.mLeftDatas != null && this.mLeftDatas.size() > 0 && (rightList = this.getSubList(this.mLeftDatas.get(0))) != null && rightList.size() > 0) {
                this.setRightAdapter(rightList);
            }
        }

        private void setRightAdapter(List<RIGHT> rightList) {
            BaseQuickAdapter rightQuickAdapter = new BaseQuickAdapter<RIGHT, BaseViewHolder>(this.getRightLayoutId(), rightList){

                protected void convert(BaseViewHolder helper, RIGHT item) {
                    this.rightConvert(helper, item);
                }
            };
            rightQuickAdapter.setOnItemClickListener(new BaseQuickAdapter.OnItemClickListener(){

                public void onItemClick(BaseQuickAdapter adapter, View view, int position) {
                    if (linkItemClickListener != null) {
                        linkItemClickListener.onItemClick(adapter, view, position);
                    }
                }
            });
            mRightCyclerView.setAdapter((RecyclerView.Adapter)rightQuickAdapter);
        }

        public abstract List<RIGHT> getSubList(LEFT var1);

        public abstract int getLeftLayoutId();

        public abstract int getRightLayoutId();

        public abstract void leftConvert(BaseViewHolder var1, LEFT var2);

        public abstract void rightConvert(BaseViewHolder var1, RIGHT var2);
    }
}

