/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.common.http;

import android.content.Context;
import com.kangxin.common.R;
import com.kangxin.common.http.api.DownloadService;
import com.kangxin.common.http.api.JsonService;
import com.kangxin.common.http.helper.OkHttpHelper;
import com.kangxin.common.http.interceptor.DownloadInterceptor;
import com.kangxin.common.http.listener.DownListener;
import com.kangxin.common.util.SchedulesSwitch;
import com.kangxin.common.util.StringsUtils;
import io.reactivex.Observable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public class RetrofitHelpr {
    private static RetrofitHelpr instance;
    private Retrofit mRetrofit;
    private OkHttpHelper okHttpHelper;
    private Retrofit.Builder builder;
    private boolean switchThread = false;
    private boolean rxSupport = false;
    private boolean cache = false;
    private boolean cookieSupport = false;
    private String baseUrl;

    private RetrofitHelpr() {
    }

    public static RetrofitHelpr getInstance() {
        if (instance == null) {
            instance = new RetrofitHelpr();
        }
        return instance;
    }

    public Retrofit.Builder getBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
        this.builder = new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        return this.builder;
    }

    public Retrofit createRetrofit(String baseUrl) {
        if (baseUrl == null || baseUrl.equals("")) {
            throw new RuntimeException(StringsUtils.getString(R.string.common_baseurl_shikongde));
        }
        if (this.builder == null) {
            this.getBuilder(baseUrl);
        }
        this.mRetrofit = this.builder.client(this.createOkHttpHelper().getOkHttpClient()).build();
        return this.mRetrofit;
    }

    public <T> T createApi(Class<T> clazz) {
        if (this.mRetrofit == null) {
            this.createRetrofit(null);
        }
        return (T)this.mRetrofit.create(clazz);
    }

    public RetrofitHelpr cacheSupport(boolean cacheSupport) {
        this.cache = cacheSupport;
        return this;
    }

    public RetrofitHelpr cookieSupport(boolean cookieSupport, Context context) {
        this.cookieSupport = cookieSupport;
        this.okHttpHelper.cookieSupport(context);
        return this;
    }

    public RetrofitHelpr rxSupport(boolean rxSupport) {
        this.rxSupport = rxSupport;
        return this;
    }

    public RetrofitHelpr switchThread(boolean switchThread) {
        this.switchThread = switchThread;
        return this;
    }

    private OkHttpHelper createOkHttpHelper() {
        if (this.okHttpHelper == null) {
            this.okHttpHelper = new OkHttpHelper();
        }
        return this.okHttpHelper;
    }

    public void addInterceptor(Interceptor interceptor, int level) {
        if (this.okHttpHelper == null) {
            this.createOkHttpHelper();
        }
        this.mRetrofit = this.builder.client(this.okHttpHelper.addInterceptor(interceptor, level)).build();
    }

    public void json(String url, String json, Callback<String> callback) {
        RequestBody jsonBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        JsonService api = this.createApi(JsonService.class);
        api.sendJson(url, jsonBody).enqueue(callback);
    }

    public <T> Observable<T> json(String url, String json) {
        RequestBody jsonBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)json);
        JsonService api = this.createApi(JsonService.class);
        Observable observable = api.sendJsonRx(url, jsonBody);
        if (this.rxSupport && this.switchThread) {
            observable = observable.compose(SchedulesSwitch.applySchedulers());
        }
        return observable;
    }

    public void downloadFile(String url, final String path, final DownListener downListener) {
        OkHttpClient httpClient = new OkHttpClient.Builder().retryOnConnectionFailure(true).connectTimeout(5000L, TimeUnit.SECONDS).addInterceptor((Interceptor)new DownloadInterceptor(downListener)).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(httpClient).build();
        DownloadService downloadService = (DownloadService)retrofit.create(DownloadService.class);
        downloadService.downloadFile(url).enqueue((Callback)new Callback<ResponseBody>(){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                final InputStream inputStream = ((ResponseBody)response.body()).byteStream();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        RetrofitHelpr.this.writeFile(inputStream, path, downListener);
                        downListener.downSuccess();
                    }
                }).start();
            }

            public void onFailure(Call<ResponseBody> call, Throwable t) {
                downListener.downFail();
            }
        });
    }

    private void writeFile(InputStream inputString, String filePath, DownListener listener2) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = null;
        try {
            int len;
            fos = new FileOutputStream(file);
            byte[] b = new byte[1024];
            while ((len = inputString.read(b)) != -1) {
                fos.write(b, 0, len);
            }
            inputString.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            listener2.downFail();
        }
        catch (IOException e) {
            listener2.downFail();
        }
    }
}

